/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.tileentities.Screen;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RotationOffset {
    public float leftTop;
    public float leftBottom;
    public float rightTop;
    public float rightBottom;
    public int thickness;
    public int rotateHor;
    public int rotateVert;

    public RotationOffset() {
        this.leftTop = 0.0f;
        this.leftBottom = 0.0f;
        this.rightTop = 0.0f;
        this.rightBottom = 0.0f;
    }

    public RotationOffset(int thickness, int rotateHor, int rotateVert) {
        this.thickness = thickness;
        this.rotateHor = rotateHor;
        this.rotateVert = rotateVert;
        if (rotateVert == 0) {
            if (rotateHor < 0) {
                this.leftTop -= (float)rotateHor / 4.0f * 16.0f;
                this.leftBottom -= (float)rotateHor / 4.0f * 16.0f;
            } else {
                this.rightTop += (float)rotateHor / 4.0f * 16.0f;
                this.rightBottom += (float)rotateHor / 4.0f * 16.0f;
            }
        } else if (rotateHor < 0) {
            this.leftTop -= (float)rotateHor / 4.0f * 16.0f / 2.0f;
            this.leftBottom -= (float)rotateHor / 4.0f * 16.0f / 2.0f;
        } else {
            this.rightTop += (float)rotateHor / 4.0f * 16.0f / 2.0f;
            this.rightBottom += (float)rotateHor / 4.0f * 16.0f / 2.0f;
        }
        if (rotateHor == 0) {
            if (rotateVert < 0) {
                this.leftTop -= (float)rotateVert / 4.0f * 16.0f;
                this.rightTop -= (float)rotateVert / 4.0f * 16.0f;
            } else {
                this.leftBottom += (float)rotateVert / 4.0f * 16.0f;
                this.rightBottom += (float)rotateVert / 4.0f * 16.0f;
            }
        } else if (rotateVert < 0) {
            this.leftTop -= (float)rotateVert / 4.0f * 16.0f / 2.0f;
            this.rightTop -= (float)rotateVert / 4.0f * 16.0f / 2.0f;
        } else {
            this.leftBottom += (float)rotateVert / 4.0f * 16.0f / 2.0f;
            this.rightBottom += (float)rotateVert / 4.0f * 16.0f / 2.0f;
        }
        this.leftTop = 32.0f - (32.0f - this.leftTop) / 32.0f * (float)thickness;
        this.leftBottom = 32.0f - (32.0f - this.leftBottom) / 32.0f * (float)thickness;
        this.rightTop = 32.0f - (32.0f - this.rightTop) / 32.0f * (float)thickness;
        this.rightBottom = 32.0f - (32.0f - this.rightBottom) / 32.0f * (float)thickness;
    }

    private void updateOffset(RotationOffset offset, float length, int pos, int state) {
        offset.leftTop += length * (float)(pos + (state >> 3 & 1));
        offset.rightTop += length * (float)(pos + (state >> 2 & 1));
        offset.leftBottom += length * (float)(pos + (state >> 1 & 1));
        offset.rightBottom += length * (float)(pos + (state & 1));
    }

    public RotationOffset addOffset(Screen screen, BlockPos pos, EnumFacing facing, EnumFacing rotation) {
        if (this.rotateHor == 0 && this.rotateVert == 0) {
            return this;
        }
        RotationOffset offset = new RotationOffset();
        float lengthX = (this.leftTop - this.rightTop) / (float)(screen.maxX - screen.minX + 1);
        float lengthYX = (this.leftTop - this.leftBottom) / (float)(screen.maxX - screen.minX + 1);
        float lengthY = (this.leftTop - this.leftBottom) / (float)(screen.maxY - screen.minY + 1);
        float lengthZ = (this.leftTop - this.rightTop) / (float)(screen.maxZ - screen.minZ + 1);
        float lengthYZ = (this.leftTop - this.leftBottom) / (float)(screen.maxZ - screen.minZ + 1);
        switch (facing) {
            case NORTH: {
                if (this.rotateVert > 0) {
                    this.updateOffset(offset, -lengthY, screen.maxY - pos.func_177956_o(), 3);
                }
                if (this.rotateVert < 0) {
                    this.updateOffset(offset, lengthY, pos.func_177956_o() - screen.minY, 12);
                }
                if (this.rotateHor > 0) {
                    this.updateOffset(offset, -lengthX, screen.maxX - pos.func_177958_n(), 5);
                }
                if (this.rotateHor >= 0) break;
                this.updateOffset(offset, lengthX, pos.func_177958_n() - screen.minX, 10);
                break;
            }
            case SOUTH: {
                if (this.rotateVert > 0) {
                    this.updateOffset(offset, -lengthY, screen.maxY - pos.func_177956_o(), 3);
                }
                if (this.rotateVert < 0) {
                    this.updateOffset(offset, lengthY, pos.func_177956_o() - screen.minY, 12);
                }
                if (this.rotateHor > 0) {
                    this.updateOffset(offset, -lengthX, pos.func_177958_n() - screen.minX, 5);
                }
                if (this.rotateHor >= 0) break;
                this.updateOffset(offset, lengthX, screen.maxX - pos.func_177958_n(), 10);
                break;
            }
            case EAST: {
                if (this.rotateVert > 0) {
                    this.updateOffset(offset, -lengthY, screen.maxY - pos.func_177956_o(), 3);
                }
                if (this.rotateVert < 0) {
                    this.updateOffset(offset, lengthY, pos.func_177956_o() - screen.minY, 12);
                }
                if (this.rotateHor > 0) {
                    this.updateOffset(offset, -lengthZ, screen.maxZ - pos.func_177952_p(), 5);
                }
                if (this.rotateHor >= 0) break;
                this.updateOffset(offset, lengthZ, pos.func_177952_p() - screen.minZ, 10);
                break;
            }
            case WEST: {
                if (this.rotateVert > 0) {
                    this.updateOffset(offset, -lengthY, screen.maxY - pos.func_177956_o(), 3);
                }
                if (this.rotateVert < 0) {
                    this.updateOffset(offset, lengthY, pos.func_177956_o() - screen.minY, 12);
                }
                if (this.rotateHor > 0) {
                    this.updateOffset(offset, -lengthZ, pos.func_177952_p() - screen.minZ, 5);
                }
                if (this.rotateHor >= 0) break;
                this.updateOffset(offset, lengthZ, screen.maxZ - pos.func_177952_p(), 10);
                break;
            }
            case UP: {
                switch (rotation) {
                    case NORTH: {
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYZ, screen.maxZ - pos.func_177952_p(), 3);
                        }
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYZ, pos.func_177952_p() - screen.minZ, 12);
                        }
                        if (this.rotateHor < 0) {
                            this.updateOffset(offset, lengthX, pos.func_177958_n() - screen.minX, 10);
                        }
                        if (this.rotateHor <= 0) break;
                        this.updateOffset(offset, -lengthX, screen.maxX - pos.func_177958_n(), 5);
                        break;
                    }
                    case SOUTH: {
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYZ, pos.func_177952_p() - screen.minZ, 3);
                        }
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYZ, screen.maxZ - pos.func_177952_p(), 12);
                        }
                        if (this.rotateHor > 0) {
                            this.updateOffset(offset, -lengthX, pos.func_177958_n() - screen.minX, 5);
                        }
                        if (this.rotateHor >= 0) break;
                        this.updateOffset(offset, lengthX, screen.maxX - pos.func_177958_n(), 10);
                        break;
                    }
                    case EAST: {
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYX, pos.func_177958_n() - screen.minX, 3);
                        }
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYX, screen.maxX - pos.func_177958_n(), 12);
                        }
                        if (this.rotateHor > 0) {
                            this.updateOffset(offset, -lengthZ, screen.maxZ - pos.func_177952_p(), 5);
                        }
                        if (this.rotateHor >= 0) break;
                        this.updateOffset(offset, lengthZ, pos.func_177952_p() - screen.minZ, 10);
                        break;
                    }
                    case WEST: {
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYX, screen.maxX - pos.func_177958_n(), 3);
                        }
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYX, pos.func_177958_n() - screen.minX, 12);
                        }
                        if (this.rotateHor > 0) {
                            this.updateOffset(offset, -lengthZ, pos.func_177952_p() - screen.minZ, 5);
                        }
                        if (this.rotateHor >= 0) break;
                        this.updateOffset(offset, lengthZ, screen.maxZ - pos.func_177952_p(), 10);
                    }
                }
                break;
            }
            case DOWN: {
                switch (rotation) {
                    case SOUTH: {
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYZ, screen.maxZ - pos.func_177952_p(), 12);
                        }
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYZ, pos.func_177952_p() - screen.minZ, 3);
                        }
                        if (this.rotateHor < 0) {
                            this.updateOffset(offset, lengthX, pos.func_177958_n() - screen.minX, 10);
                        }
                        if (this.rotateHor <= 0) break;
                        this.updateOffset(offset, -lengthX, screen.maxX - pos.func_177958_n(), 5);
                        break;
                    }
                    case NORTH: {
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYZ, pos.func_177952_p() - screen.minZ, 12);
                        }
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYZ, screen.maxZ - pos.func_177952_p(), 3);
                        }
                        if (this.rotateHor < 0) {
                            this.updateOffset(offset, lengthX, screen.maxX - pos.func_177958_n(), 10);
                        }
                        if (this.rotateHor <= 0) break;
                        this.updateOffset(offset, -lengthX, pos.func_177958_n() - screen.minX, 5);
                        break;
                    }
                    case WEST: {
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYX, screen.maxX - pos.func_177958_n(), 3);
                        }
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYX, pos.func_177958_n() - screen.minX, 12);
                        }
                        if (this.rotateHor > 0) {
                            this.updateOffset(offset, -lengthZ, screen.maxZ - pos.func_177952_p(), 5);
                        }
                        if (this.rotateHor >= 0) break;
                        this.updateOffset(offset, lengthZ, pos.func_177952_p() - screen.minZ, 10);
                        break;
                    }
                    case EAST: {
                        if (this.rotateVert < 0) {
                            this.updateOffset(offset, lengthYX, screen.maxX - pos.func_177958_n(), 12);
                        }
                        if (this.rotateVert > 0) {
                            this.updateOffset(offset, -lengthYX, pos.func_177958_n() - screen.minX, 3);
                        }
                        if (this.rotateHor > 0) {
                            this.updateOffset(offset, -lengthZ, pos.func_177952_p() - screen.minZ, 5);
                        }
                        if (this.rotateHor >= 0) break;
                        this.updateOffset(offset, lengthZ, screen.maxZ - pos.func_177952_p(), 10);
                    }
                }
                break;
            }
        }
        offset.leftTop += (float)(32 - this.thickness);
        offset.rightTop += (float)(32 - this.thickness);
        offset.leftBottom += (float)(32 - this.thickness);
        offset.rightBottom += (float)(32 - this.thickness);
        return offset;
    }
}

