/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.blocks.SeedLibrary;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.utils.SeedLibraryFilter;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntitySeedLibrary
extends TileEntityInventory
implements ITickable,
ITilePacketHandler,
ISlotItemFilter,
IEnergySink {
    public static final byte SLOT_DISCHARGER = 0;
    public static final byte FAKE_SLOT = 9;
    private static final double CONSUMPTION = 1.0;
    public static final int TIER = 1;
    public static final int CAPACITY = 1000;
    private double energy = 0.0;
    private boolean addedToEnet = false;
    private boolean active = false;
    protected SeedLibraryFilter[] filters = new SeedLibraryFilter[7];
    protected HashMap<String, ItemStack> deepContents = new HashMap();
    public int seeds_available;

    public TileEntitySeedLibrary() {
        super("tile.seed_library.name");
        for (int i = 0; i < this.filters.length - 1; ++i) {
            this.filters[i] = new SeedLibraryFilter(null);
        }
        this.filters[this.filters.length - 1] = new SeedLibraryFilter(this);
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean getActive() {
        return this.active;
    }

    public SeedLibraryFilter getGUIFilter() {
        return this.filters[6];
    }

    public int getSliderValue(int slider) {
        SeedLibraryFilter filter = this.getGUIFilter();
        int bar = slider / 2;
        int arrow = slider % 2;
        if (bar == 0) {
            if (arrow == 0) {
                return filter.min_growth;
            }
            return filter.max_growth;
        }
        if (bar == 1) {
            if (arrow == 0) {
                return filter.min_gain;
            }
            return filter.max_gain;
        }
        if (bar == 2) {
            if (arrow == 0) {
                return filter.min_resistance;
            }
            return filter.max_resistance;
        }
        if (arrow == 0) {
            return filter.min_total / 3;
        }
        return filter.max_total / 3;
    }

    public void setSliderValue(int slider, int value) {
        SeedLibraryFilter filter = this.getGUIFilter();
        int bar = slider / 2;
        int arrow = slider % 2;
        if (bar == 0) {
            if (arrow == 0) {
                filter.min_growth = value;
            } else {
                filter.max_growth = value;
            }
        } else if (bar == 1) {
            if (arrow == 0) {
                filter.min_gain = value;
            } else {
                filter.max_gain = value;
            }
        } else if (bar == 2) {
            if (arrow == 0) {
                filter.min_resistance = value;
            } else {
                filter.max_resistance = value;
            }
        } else if (arrow == 0) {
            filter.min_total = value * 3;
        } else {
            filter.max_total = value * 3;
        }
        filter.settingsChanged();
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("button") || !tag.func_74764_b("click")) break;
                this.actionPerformed(tag.func_74762_e("button"), tag.func_74767_n("click"));
                break;
            }
            case 2: {
                if (!tag.func_74764_b("slider") || !tag.func_74764_b("value")) break;
                this.setSliderValue(tag.func_74762_e("slider"), tag.func_74762_e("value"));
            }
        }
    }

    private void actionPerformed(int button, boolean rightClick) {
        if (button == 0) {
            this.importFromInventory();
        } else if (button == 1) {
            this.exportToInventory();
        } else if (button == 2) {
            SeedLibraryFilter filter = this.getGUIFilter();
            filter.unknown_type = (filter.unknown_type + 1) % 3;
            filter.settingsChanged();
        } else if (button == 3) {
            SeedLibraryFilter filter = this.getGUIFilter();
            filter.unknown_ggr = (filter.unknown_ggr + 1) % 3;
            filter.settingsChanged();
        } else if (button < 10) {
            int dir = button - 4;
            if (rightClick) {
                this.filters[dir].copyFrom(this.filters[6]);
                this.func_70296_d();
            } else {
                this.filters[6].copyFrom(this.filters[dir]);
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                this.getGUIFilter().loadFromNBT(tag);
                this.energy = tag.func_74769_h("energy");
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.seeds_available = tag.func_74762_e("value");
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        tag.func_74757_a("active", this.active);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.updateActive();
        tag.func_74757_a("active", this.active);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("energy")) {
            this.energy = tag.func_74769_h("energy");
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
        this.deepContents.clear();
        NBTTagList filterList = tag.func_150295_c("Filters", 10);
        for (int i = 0; i < 7; ++i) {
            this.filters[i].loadFromNBT(filterList.func_150305_b(i));
        }
        NBTTagList bufferList = tag.func_150295_c("Items_", 10);
        for (int i = 0; i < bufferList.func_74745_c(); ++i) {
            NBTTagCompound slot = bufferList.func_150305_b(i);
            byte j = slot.func_74771_c("Slot");
            ItemStack stack = new ItemStack(slot);
            if (stack.func_190926_b()) continue;
            this.loadSeed(stack);
        }
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("energy", this.energy);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagList inventoryTag = new NBTTagList();
        for (ItemStack seed : this.deepContents.values()) {
            if (seed.func_190926_b()) continue;
            NBTTagCompound seedtag = new NBTTagCompound();
            seedtag.func_74774_a("Slot", (byte)-1);
            seed.func_77955_b(seedtag);
            inventoryTag.func_74742_a((NBTBase)seedtag);
        }
        tag.func_74782_a("Items_", (NBTBase)inventoryTag);
        NBTTagList filterList = new NBTTagList();
        for (int i = 0; i < 7; ++i) {
            NBTTagCompound filtertag = new NBTTagCompound();
            this.filters[i].writeToNBT(filtertag);
            filterList.func_74742_a((NBTBase)filtertag);
        }
        tag.func_74782_a("Filters", (NBTBase)filterList);
        return this.writeProperties(tag);
    }

    public void onLoad() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    public void func_73660_a() {
        if (!this.addedToEnet) {
            this.onLoad();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && this.energy < 1000.0 && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem ielectricitem = (IElectricItem)stack.func_77973_b();
            double old = this.energy;
            if (ielectricitem.canProvideEnergy(stack)) {
                this.energy += ElectricItem.manager.discharge(stack, 1000.0 - this.energy, 1, false, false, false);
            }
            if (old == 0.0 && this.energy >= 1.0) {
                this.updateState();
            }
        }
        if (this.energy >= 1.0) {
            this.energy -= 1.0;
        } else {
            this.energy = 0.0;
            this.updateState();
        }
    }

    private void updateActive() {
        this.active = this.energy >= 1.0;
    }

    private void updateState() {
        boolean old = this.active;
        this.updateActive();
        if (this.active == old) {
            return;
        }
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof SeedLibrary) || (Boolean)iblockstate.func_177229_b((IProperty)SeedLibrary.ACTIVE) == this.active) {
            return;
        }
        IBlockState newState = block.func_176223_P().func_177226_a((IProperty)SeedLibrary.field_185512_D, iblockstate.func_177229_b((IProperty)SeedLibrary.field_185512_D)).func_177226_a((IProperty)SeedLibrary.ACTIVE, (Comparable)Boolean.valueOf(this.active));
        this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
    }

    public int func_70302_i_() {
        return 10;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return stack.func_77973_b() instanceof IElectricItem && ((IElectricItem)stack.func_77973_b()).getTier(stack) <= 1;
            }
            case 9: {
                return false;
            }
        }
        return stack.func_77973_b() == IC2Items.getItem((String)"crop_seed_bag").func_77973_b();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (slot < 1 || slot > 8) {
            return false;
        }
        return stack.func_77973_b() == IC2Items.getItem((String)"crop_seed_bag").func_77973_b();
    }

    public String getKey(ItemStack seed) {
        CropCard card = Crops.instance.getCropCard(seed);
        String owner = card.getOwner();
        String id = card.getId();
        ICropSeed item = (ICropSeed)seed.func_77973_b();
        int growth = item.getGrowthFromStack(seed);
        int gain = item.getGainFromStack(seed);
        int resistance = item.getResistanceFromStack(seed);
        int scan = item.getScannedFromStack(seed);
        return owner + ":" + id + ":" + growth + ":" + gain + ":" + resistance + ":" + scan;
    }

    private void loadSeed(ItemStack seed) {
        String key = this.getKey(seed);
        ItemStack stored = this.deepContents.get(key);
        if (stored != null && !stored.func_190926_b()) {
            stored.func_190917_f(seed.func_190916_E());
            this.updateCountIfMatch(stored);
        } else {
            stored = seed.func_77946_l();
            this.deepContents.put(key, stored);
            for (SeedLibraryFilter filter : this.filters) {
                filter.newSeed(stored);
            }
        }
    }

    private void updateCountIfMatch(ItemStack seed) {
        SeedLibraryFilter filter = this.getGUIFilter();
        if (!filter.bulk_mode && filter.isMatch(seed)) {
            this.updateSeedCount();
        }
    }

    public void updateSeedCount() {
        this.seeds_available = this.getGUIFilter().getCount(this.deepContents.values());
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.seeds_available > 65535) {
            this.seeds_available = 65535;
        }
        if (this.field_145850_b != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 2);
            tag.func_74768_a("value", this.seeds_available);
            NetworkHelper.updateClientTileEntity(this.field_145850_b, this.field_174879_c, tag);
        }
    }

    private void unloadSeed(ItemStack seed) {
        String key = this.getKey(seed);
        ItemStack stored = this.deepContents.get(key);
        if (stored == null || stored.func_190926_b()) {
            return;
        }
        ICropSeed item = (ICropSeed)stored.func_77973_b();
        if (stored.func_190916_E() <= seed.func_190916_E()) {
            this.deepContents.remove(key);
            for (SeedLibraryFilter filter : this.filters) {
                filter.lostSeed(stored);
            }
            stored.func_190918_g(seed.func_190916_E());
        } else {
            stored.func_190918_g(seed.func_190916_E());
            this.updateCountIfMatch(stored);
        }
    }

    public void importFromInventory() {
        this.getGUIFilter().bulk_mode = true;
        for (int i = 1; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != IC2Items.getItem((String)"crop_seed_bag").func_77973_b()) continue;
            this.loadSeed(stack);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.getGUIFilter().bulk_mode = false;
        this.func_70296_d();
        this.updateSeedCount();
    }

    public void exportToInventory() {
        this.getGUIFilter().bulk_mode = true;
        for (int i = 1; i < 9; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            ItemStack seed = this.filters[6].getSeed(this.deepContents.values());
            if (seed == null || seed.func_190926_b()) break;
            ItemStack stack = seed.func_77946_l();
            stack.func_190920_e(1);
            this.inventory.set(i, (Object)stack);
            this.unloadSeed(this.func_70301_a(i));
        }
        this.getGUIFilter().bulk_mode = false;
        this.func_70296_d();
        this.updateSeedCount();
    }

    public void updateGUIFilter() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70296_d();
        NBTTagCompound tag = new NBTTagCompound();
        this.getGUIFilter().writeToNBT(tag);
        tag.func_74768_a("type", 1);
        tag.func_74780_a("energy", this.energy);
        NetworkHelper.updateClientTileEntity(this.field_145850_b, this.field_174879_c, tag);
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    public double getDemandedEnergy() {
        return Math.max(0.0, 1000.0 - this.energy);
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double old = this.energy;
        this.energy += amount;
        double left = 0.0;
        if (this.energy > 1000.0) {
            left = this.energy - 1000.0;
            this.energy = 1000.0;
        }
        if (this.energy >= 1.0 && old < 1.0 && !this.field_145850_b.field_72995_K) {
            this.updateState();
        }
        return left;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

