/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.arch.types;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kr.pe.ecmaxp.openpython.arch.OpenPythonMemoryRegion;
import kr.pe.ecmaxp.openpython.arch.OpenPythonVirtualMachine;
import kr.pe.ecmaxp.openpython.arch.msgpack.Msgpack;
import kr.pe.ecmaxp.openpython.arch.types.call.InvokeResult;
import kr.pe.ecmaxp.thumbsf.CPU;
import kr.pe.ecmaxp.thumbsf.Memory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\b\u0010!\u001a\u0004\u0018\u00010\u0001J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u001eJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lkr/pe/ecmaxp/openpython/arch/types/Interrupt;", "", "cpu", "Lkr/pe/ecmaxp/thumbsf/CPU;", "imm", "", "vm", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;", "(Lkr/pe/ecmaxp/thumbsf/CPU;ILkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;)V", "getCpu", "()Lkr/pe/ecmaxp/thumbsf/CPU;", "getImm", "()I", "memory", "Lkr/pe/ecmaxp/thumbsf/Memory;", "getMemory", "()Lkr/pe/ecmaxp/thumbsf/Memory;", "r0", "getR0", "r1", "getR1", "r2", "getR2", "r3", "getR3", "r4", "getR4", "getVm", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;", "readBuffer", "", "address", "size", "readObject", "readString", "", "maxSize", "responseBuffer", "buffer", "responseError", "value", "", "responseNone", "responseResult", "ret", "Lkr/pe/ecmaxp/openpython/arch/types/call/InvokeResult;", "responseValue", "OpenPython"})
public final class Interrupt {
    private final int imm;
    private final int r0;
    private final int r1;
    private final int r2;
    private final int r3;
    private final int r4;
    @NotNull
    private final CPU cpu;
    @Nullable
    private final OpenPythonVirtualMachine vm;

    public final int getImm() {
        return this.imm;
    }

    public final int getR0() {
        return this.r0;
    }

    public final int getR1() {
        return this.r1;
    }

    public final int getR2() {
        return this.r2;
    }

    public final int getR3() {
        return this.r3;
    }

    public final int getR4() {
        return this.r4;
    }

    @NotNull
    public final Memory getMemory() {
        return this.cpu.getMemory();
    }

    @NotNull
    public final byte[] readBuffer(int address, int size) {
        return this.getMemory().readBuffer(address, size);
    }

    @NotNull
    public final byte[] readBuffer() {
        return this.readBuffer(this.r0, this.r1);
    }

    @NotNull
    public final String readString(int address, int maxSize) {
        return this.getMemory().readString(address, maxSize);
    }

    @Nullable
    public final String readString() {
        return this.readString(this.r0, this.r1);
    }

    @Nullable
    public final Object readObject() {
        return new Msgpack(this.vm).loads(this.readBuffer());
    }

    public final int responseNone() {
        return 0;
    }

    public final int responseError(@NotNull Throwable value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int bufAddress = OpenPythonMemoryRegion.SYSCALL.getAddress();
        byte[] buffer = new Msgpack(this.vm).dumps(value);
        this.getMemory().writeInt(bufAddress, 0);
        this.getMemory().writeInt(bufAddress + 4, bufAddress + 12);
        this.getMemory().writeInt(bufAddress + 8, buffer.length);
        this.getMemory().writeBuffer(bufAddress + 12, buffer);
        return bufAddress;
    }

    public final int responseValue(@Nullable Object value) {
        if (value == null) {
            return this.responseNone();
        }
        int bufAddress = OpenPythonMemoryRegion.SYSCALL.getAddress();
        byte[] buffer = new Msgpack(this.vm).dumps(value);
        this.getMemory().writeInt(bufAddress, 1);
        this.getMemory().writeInt(bufAddress + 4, bufAddress + 12);
        this.getMemory().writeInt(bufAddress + 8, buffer.length);
        this.getMemory().writeBuffer(bufAddress + 12, buffer);
        return bufAddress;
    }

    public final int responseBuffer(@NotNull byte[] buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int bufAddress = OpenPythonMemoryRegion.SYSCALL.getAddress();
        this.getMemory().writeInt(bufAddress, bufAddress + 8);
        this.getMemory().writeInt(bufAddress + 4, buffer.length);
        this.getMemory().writeBuffer(bufAddress + 8, buffer);
        this.getMemory().writeByte(bufAddress + 8 + buffer.length, (byte)0);
        return bufAddress;
    }

    public final int responseResult(@NotNull InvokeResult ret) {
        Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
        return ret.getError() == null ? this.responseValue(ret.getArgs()) : this.responseError(ret.getError());
    }

    @NotNull
    public final CPU getCpu() {
        return this.cpu;
    }

    @Nullable
    public final OpenPythonVirtualMachine getVm() {
        return this.vm;
    }

    public Interrupt(@NotNull CPU cpu, int imm, @Nullable OpenPythonVirtualMachine vm) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)cpu, (String)"cpu");
        this.cpu = cpu;
        this.vm = vm;
        boolean bl2 = bl = imm == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.imm = this.cpu.getRegs().get(7);
        this.r0 = this.cpu.getRegs().get(0);
        this.r1 = this.cpu.getRegs().get(1);
        this.r2 = this.cpu.getRegs().get(2);
        this.r3 = this.cpu.getRegs().get(3);
        this.r4 = this.cpu.getRegs().get(4);
    }

    public /* synthetic */ Interrupt(CPU cPU, int n, OpenPythonVirtualMachine openPythonVirtualMachine, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            openPythonVirtualMachine = null;
        }
        this(cPU, n, openPythonVirtualMachine);
    }
}

