/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.core;

import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.Preconditions;

public class ExtensionTypeHeader {
    private final byte type;
    private final int length;

    public ExtensionTypeHeader(byte type, int length) {
        Preconditions.checkArgument(length >= 0, "length must be >= 0");
        this.type = type;
        this.length = length;
    }

    public static byte checkedCastToByte(int code) {
        Preconditions.checkArgument(-128 <= code && code <= 127, "Extension type code must be within the range of byte");
        return (byte)code;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return (this.type + 31) * 31 + this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionTypeHeader) {
            ExtensionTypeHeader other = (ExtensionTypeHeader)obj;
            return this.type == other.type && this.length == other.length;
        }
        return false;
    }

    public String toString() {
        return String.format("ExtensionTypeHeader(type:%d, length:%,d)", this.type, this.length);
    }
}

