/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer;

import java.util.ArrayList;
import java.util.List;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBuffer;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBufferOutput;

public class ArrayBufferOutput
implements MessageBufferOutput {
    private final List<MessageBuffer> list;
    private final int bufferSize;
    private MessageBuffer lastBuffer;

    public ArrayBufferOutput() {
        this(8192);
    }

    public ArrayBufferOutput(int bufferSize) {
        this.bufferSize = bufferSize;
        this.list = new ArrayList<MessageBuffer>();
    }

    public int getSize() {
        int size = 0;
        for (MessageBuffer buffer : this.list) {
            size += buffer.size();
        }
        return size;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.getSize()];
        int off = 0;
        for (MessageBuffer buffer : this.list) {
            buffer.getBytes(0, data, off, buffer.size());
            off += buffer.size();
        }
        return data;
    }

    public MessageBuffer toMessageBuffer() {
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        if (this.list.isEmpty()) {
            return MessageBuffer.allocate(0);
        }
        return MessageBuffer.wrap(this.toByteArray());
    }

    public List<MessageBuffer> toBufferList() {
        return new ArrayList<MessageBuffer>(this.list);
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public MessageBuffer next(int minimumSize) {
        MessageBuffer buffer;
        if (this.lastBuffer != null && this.lastBuffer.size() > minimumSize) {
            return this.lastBuffer;
        }
        int size = Math.max(this.bufferSize, minimumSize);
        this.lastBuffer = buffer = MessageBuffer.allocate(size);
        return buffer;
    }

    @Override
    public void writeBuffer(int length) {
        this.list.add(this.lastBuffer.slice(0, length));
        this.lastBuffer = this.lastBuffer.size() - length > this.bufferSize / 4 ? this.lastBuffer.slice(length, this.lastBuffer.size() - length) : null;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        MessageBuffer copy = MessageBuffer.allocate(length);
        copy.putBytes(0, buffer, offset, length);
        this.list.add(copy);
    }

    @Override
    public void add(byte[] buffer, int offset, int length) {
        MessageBuffer wrapped = MessageBuffer.wrap(buffer, offset, length);
        this.list.add(wrapped);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

