/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl;

import java.io.IOException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessagePacker;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableBooleanValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.Value;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ValueType;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.AbstractImmutableValue;

public class ImmutableBooleanValueImpl
extends AbstractImmutableValue
implements ImmutableBooleanValue {
    public static final ImmutableBooleanValue TRUE = new ImmutableBooleanValueImpl(true);
    public static final ImmutableBooleanValue FALSE = new ImmutableBooleanValueImpl(false);
    private final boolean value;

    private ImmutableBooleanValueImpl(boolean value) {
        this.value = value;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public ImmutableBooleanValue asBooleanValue() {
        return this;
    }

    @Override
    public ImmutableBooleanValue immutableValue() {
        return this;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker packer) throws IOException {
        packer.packBoolean(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isBooleanValue()) {
            return false;
        }
        return this.value == v.asBooleanValue().getBoolean();
    }

    public int hashCode() {
        if (this.value) {
            return 1231;
        }
        return 1237;
    }

    @Override
    public String toJson() {
        return Boolean.toString(this.value);
    }

    public String toString() {
        return this.toJson();
    }
}

