/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.RequiredExtractorConstant;
import buildcraft.builders.snapshot.RequiredExtractorItem;
import buildcraft.builders.snapshot.RequiredExtractorItemFromBlock;
import buildcraft.builders.snapshot.RequiredExtractorItemsList;
import buildcraft.builders.snapshot.RequiredExtractorTank;
import com.google.gson.JsonDeserializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class RequiredExtractor {
    public static final JsonDeserializer<RequiredExtractor> DESERIALIZER = (json, typeOfT, context) -> {
        EnumType type = EnumType.byName(json.getAsJsonObject().get("type").getAsString());
        json.getAsJsonObject().remove("type");
        return (RequiredExtractor)context.deserialize(json, type.clazz);
    };

    @Nonnull
    public List<ItemStack> extractItemsFromBlock(@Nonnull IBlockState blockState, @Nullable NBTTagCompound tileNbt) {
        return Collections.emptyList();
    }

    @Nonnull
    public List<FluidStack> extractFluidsFromBlock(@Nonnull IBlockState blockState, @Nullable NBTTagCompound tileNbt) {
        return Collections.emptyList();
    }

    @Nonnull
    public List<ItemStack> extractItemsFromEntity(@Nonnull NBTTagCompound entityNbt) {
        return Collections.emptyList();
    }

    @Nonnull
    public List<FluidStack> extractFluidsFromEntity(@Nonnull NBTTagCompound entityNbt) {
        return Collections.emptyList();
    }

    public static enum EnumType {
        CONSTANT(RequiredExtractorConstant.class),
        ITEM_FROM_BLOCK(RequiredExtractorItemFromBlock.class),
        ITEM(RequiredExtractorItem.class),
        ITEMS_LIST(RequiredExtractorItemsList.class),
        TANK(RequiredExtractorTank.class);

        public final Class<? extends RequiredExtractor> clazz;

        private EnumType(Class<? extends RequiredExtractor> clazz) {
            this.clazz = clazz;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static EnumType byName(String name) {
            return Arrays.stream(EnumType.values()).filter(type -> type.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Required extractor type not found"));
        }
    }
}

