/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pcl.openprinter.OpenPrinter;
import pcl.openprinter.blocks.BlockBriefcase;
import pcl.openprinter.blocks.BlockFileCabinet;
import pcl.openprinter.blocks.BlockPrinter;
import pcl.openprinter.blocks.BlockShredder;
import pcl.openprinter.items.ItemBriefcase;
import pcl.openprinter.items.ItemFolder;
import pcl.openprinter.items.ItemPaperShreds;
import pcl.openprinter.items.PrintedPage;
import pcl.openprinter.items.PrinterInkBlack;
import pcl.openprinter.items.PrinterInkColor;
import pcl.openprinter.manual.Manual;
import pcl.openprinter.tileentity.BriefcaseTE;
import pcl.openprinter.tileentity.FileCabinetTE;
import pcl.openprinter.tileentity.PrinterTE;
import pcl.openprinter.tileentity.ShredderTE;

public class ContentRegistry {
    public static final HashSet<ItemStack> modItems = new HashSet();
    public static Block printerBlock;
    static Block shredderBlock;
    static Block fileCabinetBlock;
    public static Item printedPage;
    static Item printerInkColor;
    static Item printerInkBlack;
    static Block briefcaseBlock;
    static Item briefcaseItem;
    public static Item shreddedPaper;
    static Item folder;

    protected ContentRegistry() {
    }

    public void preInit() {
        for (Item manualItem : Manual.items) {
            modItems.add(new ItemStack(manualItem));
        }
        printerBlock = ContentRegistry.init((Block)new BlockPrinter(), "printer");
        shredderBlock = ContentRegistry.init((Block)new BlockShredder(), "shredder");
        briefcaseBlock = ContentRegistry.init((Block)new BlockBriefcase(), "briefcase");
        fileCabinetBlock = ContentRegistry.init((Block)new BlockFileCabinet(), "filecabinet");
        GameRegistry.registerTileEntity(PrinterTE.class, (ResourceLocation)new ResourceLocation("openprinter", "printer_tileentity"));
        GameRegistry.registerTileEntity(ShredderTE.class, (ResourceLocation)new ResourceLocation("openprinter", "shredder_tileentity"));
        GameRegistry.registerTileEntity(BriefcaseTE.class, (ResourceLocation)new ResourceLocation("openprinter", "briefcase_tileentity"));
        GameRegistry.registerTileEntity(FileCabinetTE.class, (ResourceLocation)new ResourceLocation("openprinter", "filecabinet_tileentity"));
    }

    public static Item init(Item item, String name) {
        return (Item)item.func_77655_b("openprinter." + name).setRegistryName("openprinter:" + name);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> register) {
        shreddedPaper = new ItemPaperShreds();
        register.getRegistry().register((IForgeRegistryEntry)ContentRegistry.init(shreddedPaper, "paper_shreds"));
        printerInkColor = new PrinterInkColor();
        register.getRegistry().register((IForgeRegistryEntry)ContentRegistry.init(printerInkColor, "printer_ink_color"));
        printerInkBlack = new PrinterInkBlack();
        register.getRegistry().register((IForgeRegistryEntry)ContentRegistry.init(printerInkBlack, "printer_ink_black"));
        printedPage = new PrintedPage();
        register.getRegistry().register((IForgeRegistryEntry)ContentRegistry.init(printedPage, "printed_page"));
        folder = new ItemFolder();
        register.getRegistry().register((IForgeRegistryEntry)ContentRegistry.init(folder, "folder"));
        for (ItemStack item : modItems) {
            register.getRegistry().register((IForgeRegistryEntry)item.func_77973_b());
        }
        briefcaseItem = (Item)new ItemBriefcase(briefcaseBlock).func_77637_a(OpenPrinter.CreativeTab).setRegistryName(briefcaseBlock.getRegistryName());
        register.getRegistry().register(new ItemBlock(printerBlock).func_77637_a(OpenPrinter.CreativeTab).setRegistryName(printerBlock.getRegistryName()));
        register.getRegistry().register(new ItemBlock(shredderBlock).func_77637_a(OpenPrinter.CreativeTab).setRegistryName(shredderBlock.getRegistryName()));
        register.getRegistry().register(new ItemBlock(fileCabinetBlock).func_77637_a(OpenPrinter.CreativeTab).setRegistryName(fileCabinetBlock.getRegistryName()));
        register.getRegistry().register((IForgeRegistryEntry)briefcaseItem);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> register) {
        register.getRegistry().register((IForgeRegistryEntry)printerBlock);
        register.getRegistry().register((IForgeRegistryEntry)shredderBlock);
        register.getRegistry().register((IForgeRegistryEntry)fileCabinetBlock);
        register.getRegistry().register((IForgeRegistryEntry)briefcaseBlock);
    }

    public static Block init(Block block, String name) {
        return (Block)block.func_149663_c("openprinter." + name).setRegistryName("openprinter:" + name);
    }
}

