/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.openprinter.Config;
import pcl.openprinter.ContentRegistry;
import pcl.openprinter.client.CreativeTab;
import pcl.openprinter.gui.GUIHandler;
import pcl.openprinter.items.ItemFolder;
import pcl.openprinter.manual.Manual;
import pcl.openprinter.network.PacketHandler;
import pcl.openprinter.util.CharacterWidth;
import pcl.openprinter.util.ocLootDisk;

@Mod(modid="openprinter", name="OpenPrinter", version="0.1.0.21", dependencies="required-after:opencomputers;after:rtfm", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class OpenPrinter {
    public static final String MODID = "openprinter";
    @Mod.Instance(value="openprinter")
    public static OpenPrinter instance;
    public static Config cfg;
    public static boolean verbose;
    public static final Logger logger;
    public static CreativeTabs CreativeTab;
    private static ContentRegistry contentRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CharacterWidth.initWidths();
        MinecraftForge.EVENT_BUS.register((Object)contentRegistry);
        PacketHandler.init();
        cfg = new Config(new Configuration(event.getSuggestedConfigurationFile()));
        Manual.preInit();
        contentRegistry.preInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ocLootDisk.register();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
    }

    static {
        cfg = null;
        verbose = false;
        logger = LogManager.getFormatterLogger((String)MODID);
        CreativeTab = new CreativeTab("OpenPrinter");
        contentRegistry = new ContentRegistry();
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void onItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().func_186730_a((stack, layer) -> ItemFolder.getFolderColor(stack), new Item[]{ContentRegistry.folder});
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void onRegisterModels(ModelRegistryEvent event) {
            OBJLoader.INSTANCE.addDomain(OpenPrinter.MODID);
            ObjectRegistryHandler.registerBlockModel(ContentRegistry.printerBlock, 0, "printer");
            ObjectRegistryHandler.registerBlockModel(ContentRegistry.shredderBlock, 0, "shredder");
            ObjectRegistryHandler.registerBlockModel(ContentRegistry.fileCabinetBlock, 0, "filecabinet");
            ObjectRegistryHandler.registerBlockModel(ContentRegistry.briefcaseBlock, 0, "briefcase");
            ObjectRegistryHandler.registerItemModel(ContentRegistry.printedPage, "printed_page");
            ObjectRegistryHandler.registerItemModel(ContentRegistry.printerInkBlack, "printer_ink_black");
            ObjectRegistryHandler.registerItemModel(ContentRegistry.printerInkColor, "printer_ink_color");
            ObjectRegistryHandler.registerItemModel(ContentRegistry.shreddedPaper, "shredded_paper");
            ObjectRegistryHandler.registerItemModel(ContentRegistry.folder, "folder");
            for (ItemStack item : ContentRegistry.modItems) {
                ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)0, (ModelResourceLocation)new ModelResourceLocation(item.func_77973_b().getRegistryName(), "inventory"));
            }
        }

        @SideOnly(value=Side.CLIENT)
        private static void registerBlockModel(Block block, int meta, String blockName) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation("openprinter:" + blockName.toLowerCase(), "inventory"));
            if (verbose) {
                logger.info("Registering " + blockName.toLowerCase() + " Item Renderer");
            }
        }

        @SideOnly(value=Side.CLIENT)
        private static void registerItemModel(Item item, String itemName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("openprinter:" + itemName.toLowerCase(), "inventory"));
            if (verbose) {
                logger.info("Registering " + itemName.toLowerCase() + " Item Renderer");
            }
        }
    }
}

