/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pcl.openprinter.ContentRegistry;
import pcl.openprinter.items.PrintedPage;
import pcl.openprinter.util.ItemUtils;

public class ShredderTE
extends TileEntity
implements ITickable {
    private ItemStackHandler inventoryOutput = new ItemStackHandler(9);
    private ItemStackHandler inventoryInput = new ShredderInput();
    private int processingTime = 0;

    @Deprecated
    private void readOldInventoryFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Items")) {
            return;
        }
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 == 0) {
                this.inventoryInput.setStackInSlot(0, new ItemStack(var4));
                continue;
            }
            if (var5 - 1 >= this.inventoryOutput.getSlots()) continue;
            this.inventoryOutput.setStackInSlot(var5 - 1, new ItemStack(var4));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inventoryOut") && nbt.func_74764_b("inventoryIn")) {
            this.inventoryOutput.deserializeNBT(nbt.func_74775_l("inventoryOut"));
            this.inventoryInput.deserializeNBT(nbt.func_74775_l("inventoryIn"));
        } else {
            this.readOldInventoryFromNBT(nbt);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("inventoryOut", (NBTBase)this.inventoryOutput.serializeNBT());
        nbt.func_74782_a("inventoryIn", (NBTBase)this.inventoryInput.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public void func_73660_a() {
        ItemStack inputStack = this.inventoryInput.getStackInSlot(0);
        if (inputStack.func_190926_b()) {
            return;
        }
        ++this.processingTime;
        if (this.processingTime > 10) {
            int outCount = 1;
            if (inputStack.func_77973_b().getRegistryName().toString().equals("bibliocraft:bigbook")) {
                outCount = 11;
            } else if (inputStack.func_77973_b().equals(Items.field_151122_aG) || inputStack.func_77973_b().equals(Items.field_151099_bA) || inputStack.func_77973_b().equals(Items.field_151164_bB)) {
                outCount = 3;
            }
            ItemStack left = new ItemStack(ContentRegistry.shreddedPaper, outCount);
            for (int slot = 0; slot < this.inventoryOutput.getSlots() && !(left = this.inventoryOutput.insertItem(slot, left, false)).func_190926_b(); ++slot) {
            }
            this.inventoryInput.extractItem(0, 1, false);
            this.processingTime = 0;
        }
    }

    public void removed() {
        ItemUtils.dropItems(this.inventoryInput, this.field_145850_b, this.func_174877_v(), true, 10);
        ItemUtils.dropItems(this.inventoryOutput, this.field_145850_b, this.func_174877_v(), true, 10);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (EnumFacing.UP.equals((Object)facing)) {
                return (T)this.inventoryInput;
            }
            return (T)this.inventoryOutput;
        }
        return (T)super.getCapability(capability, facing);
    }

    class ShredderInput
    extends ItemStackHandler {
        ShredderInput() {
            super(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof PrintedPage || stack.func_77973_b().equals(Items.field_151164_bB) || stack.func_77973_b().equals(Items.field_151099_bA) || stack.func_77973_b().equals(Items.field_151121_aF) || stack.func_77973_b().equals(Items.field_151122_aG) || stack.func_77973_b().getRegistryName().toString().equals("bibliocraft:bigbook");
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    }
}

