/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.gui.GuiPanelBase;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.gui.GuiBase;
import com.zuxelus.zlib.gui.controls.GuiTextNumeric;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenColor
extends GuiBase {
    private static final ResourceLocation PICKER = new ResourceLocation("energycontrol:textures/gui/gui_color_picker.png");
    private GuiPanelBase parentGui;
    private int colorText;
    private int colorBack;
    private TileEntityInfoPanel panel;
    private ArrayList<GuiTextNumeric> fieldList = new ArrayList();
    private ArrayList<GuiTextNumeric> fieldList2 = new ArrayList();
    protected GuiTextNumeric rText;
    protected GuiTextNumeric gText;
    protected GuiTextNumeric bText;
    private boolean isDarkPicker;
    protected GuiTextNumeric rText2;
    protected GuiTextNumeric gText2;
    protected GuiTextNumeric bText2;
    private boolean isDarkPicker2;
    int offset;

    public GuiScreenColor(GuiPanelBase parentGui, TileEntityInfoPanel panel) {
        super("", 234, 120, "energycontrol:textures/gui/gui_colors.png");
        this.parentGui = parentGui;
        this.panel = panel;
        this.colorBack = panel.getColorBackground();
        this.colorText = panel.getColorText();
        this.offset = 116;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.fieldList.clear();
        this.rText = new GuiTextNumeric(0, this.field_146289_q, 10, 18, 26, 12, 255);
        this.rText.func_146203_f(3);
        this.rText.func_146180_a(Integer.toString((this.colorText & 0xFF0000) >> 16));
        this.fieldList.add(this.rText);
        this.gText = new GuiTextNumeric(0, this.field_146289_q, 46, 18, 26, 12, 255);
        this.gText.func_146203_f(3);
        this.gText.func_146180_a(Integer.toString((this.colorText & 0xFF00) >> 8));
        this.fieldList.add(this.gText);
        this.bText = new GuiTextNumeric(0, this.field_146289_q, 82, 18, 26, 12, 255);
        this.bText.func_146203_f(3);
        this.bText.func_146180_a(Integer.toString(this.colorText & 0xFF));
        this.fieldList.add(this.bText);
        this.fieldList2.clear();
        this.rText2 = new GuiTextNumeric(0, this.field_146289_q, 10 + this.offset, 18, 26, 12, 255);
        this.rText2.func_146203_f(3);
        this.rText2.func_146180_a(Integer.toString((this.colorBack & 0xFF0000) >> 16));
        this.fieldList2.add(this.rText2);
        this.gText2 = new GuiTextNumeric(0, this.field_146289_q, 46 + this.offset, 18, 26, 12, 255);
        this.gText2.func_146203_f(3);
        this.gText2.func_146180_a(Integer.toString((this.colorBack & 0xFF00) >> 8));
        this.fieldList2.add(this.gText2);
        this.bText2 = new GuiTextNumeric(0, this.field_146289_q, 82 + this.offset, 18, 26, 12, 255);
        this.bText2.func_146203_f(3);
        this.bText2.func_146180_a(Integer.toString(this.colorBack & 0xFF));
        this.fieldList2.add(this.bText2);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"msg.ec.ScreenColor", (Object[])new Object[0]), 152, 6, this.colorBack);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"msg.ec.TextColor", (Object[])new Object[0]), 8, 6, this.colorText);
        for (GuiTextNumeric text : this.fieldList) {
            text.func_146194_f();
        }
        for (GuiTextNumeric text : this.fieldList2) {
            text.func_146194_f();
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(PICKER);
        GuiScreenColor.func_146110_a((int)(this.guiLeft + 20), (int)(this.guiTop + 34), (float)(this.isDarkPicker ? 80.0f : 0.0f), (float)0.0f, (int)80, (int)80, (float)160.0f, (float)80.0f);
        GuiScreenColor.func_146110_a((int)(this.guiLeft + 20 + this.offset), (int)(this.guiTop + 34), (float)(this.isDarkPicker2 ? 80.0f : 0.0f), (float)0.0f, (int)80, (int)80, (float)160.0f, (float)80.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (GuiTextNumeric text : this.fieldList) {
                text.func_146192_a(mouseX - this.guiLeft, mouseY - this.guiTop, mouseButton);
            }
            for (GuiTextNumeric text : this.fieldList2) {
                text.func_146192_a(mouseX - this.guiLeft, mouseY - this.guiTop, mouseButton);
            }
            this.checkColorPicker(mouseX - this.guiLeft, mouseY - this.guiTop);
            this.checkColorPicker2(mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    private void checkColorPicker(int mouseX, int mouseY) {
        if (this.isInside(mouseX, mouseY, 10, 40, 8, 8)) {
            this.isDarkPicker = false;
            return;
        }
        if (this.isInside(mouseX, mouseY, 100, 40, 8, 8)) {
            this.isDarkPicker = true;
            return;
        }
        if (this.isInside(mouseX, mouseY, 20, 34, 80, 80)) {
            int x = mouseX - 20 - 40;
            int y = mouseY - 34 - 40;
            float saturation = (float)Math.sqrt(x * x + y * y) / 36.0f;
            if (saturation > 1.0f) {
                return;
            }
            int hue = (int)(x == 0 ? 0L : Math.round(Math.toDegrees(Math.atan(Math.abs(y / x)))));
            if (x <= 0 && y >= 0) {
                hue = 180 - hue;
            } else if (x <= 0 && y <= 0) {
                hue = 180 + hue;
            } else if (x >= 0 && y <= 0) {
                hue = 360 - hue;
            }
            if (hue > 360) {
                hue = 359;
            }
            Color c = this.isDarkPicker ? this.getColorFromHSV(hue, 1.0f, saturation) : this.getColorFromHSV(hue, saturation, 1.0f);
            this.setColorText(c);
            this.fieldList.get(0).func_146180_a(Integer.toString(c.getRed()));
            this.fieldList.get(1).func_146180_a(Integer.toString(c.getGreen()));
            this.fieldList.get(2).func_146180_a(Integer.toString(c.getBlue()));
        }
    }

    private void checkColorPicker2(int mouseX, int mouseY) {
        if (this.isInside(mouseX, mouseY, 10 + this.offset, 40, 8, 8)) {
            this.isDarkPicker2 = false;
            return;
        }
        if (this.isInside(mouseX, mouseY, 100 + this.offset, 40, 8, 8)) {
            this.isDarkPicker2 = true;
            return;
        }
        if (this.isInside(mouseX, mouseY, 20 + this.offset, 34, 80, 80)) {
            int x = mouseX - 20 - 40 - this.offset;
            int y = mouseY - 34 - 40;
            float saturation = (float)Math.sqrt(x * x + y * y) / 36.0f;
            if (saturation > 1.0f) {
                return;
            }
            int hue = (int)(x == 0 ? 0L : Math.round(Math.toDegrees(Math.atan(Math.abs(y / x)))));
            if (x <= 0 && y >= 0) {
                hue = 180 - hue;
            } else if (x <= 0 && y <= 0) {
                hue = 180 + hue;
            } else if (x >= 0 && y <= 0) {
                hue = 360 - hue;
            }
            if (hue > 360) {
                hue = 359;
            }
            Color c = this.isDarkPicker2 ? this.getColorFromHSV(hue, 1.0f, saturation) : this.getColorFromHSV(hue, saturation, 1.0f);
            this.setColorBackground(c);
            this.fieldList2.get(0).func_146180_a(Integer.toString(c.getRed()));
            this.fieldList2.get(1).func_146180_a(Integer.toString(c.getGreen()));
            this.fieldList2.get(2).func_146180_a(Integer.toString(c.getBlue()));
        }
    }

    private Color getColorFromHSV(int hue, float saturation, float value) {
        float c = saturation * value;
        float x = c * (1.0f - Math.abs((float)hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        if (hue < 60) {
            return new Color(c + m, x + m, m);
        }
        if (hue < 120) {
            return new Color(x + m, c + m, m);
        }
        if (hue < 180) {
            return new Color(m, c + m, x + m);
        }
        if (hue < 240) {
            return new Color(m, x + m, c + m);
        }
        if (hue < 300) {
            return new Color(x + m, m, c + m);
        }
        return new Color(c + m, m, x + m);
    }

    private void setColorText(Color c) {
        this.colorText = c.getRGB();
        NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 7, this.colorText);
        this.panel.setColorText(this.colorText);
    }

    private void setColorBackground(Color c) {
        this.colorBack = c.getRGB();
        NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 6, this.colorBack);
        this.panel.setColorBackground(this.colorBack);
    }

    private boolean isInside(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextNumeric text : this.fieldList) {
            text.func_146178_a();
        }
        for (GuiTextNumeric text : this.fieldList2) {
            text.func_146178_a();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        block3: {
            Color c;
            String value;
            block4: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block2: {
                                        if (keyCode != 1) break block2;
                                        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)this.parentGui);
                                        break block3;
                                    }
                                    if (keyCode != 15) break block4;
                                    if (!this.fieldList.get(0).func_146206_l()) break block5;
                                    this.fieldList.get(0).func_146195_b(false);
                                    this.fieldList.get(1).func_146195_b(true);
                                    break block3;
                                }
                                if (!this.fieldList.get(1).func_146206_l()) break block6;
                                this.fieldList.get(1).func_146195_b(false);
                                this.fieldList.get(2).func_146195_b(true);
                                break block3;
                            }
                            if (!this.fieldList.get(2).func_146206_l()) break block7;
                            this.fieldList.get(2).func_146195_b(false);
                            this.fieldList2.get(0).func_146195_b(true);
                            break block3;
                        }
                        if (!this.fieldList2.get(0).func_146206_l()) break block8;
                        this.fieldList2.get(0).func_146195_b(false);
                        this.fieldList2.get(1).func_146195_b(true);
                        break block3;
                    }
                    if (!this.fieldList2.get(1).func_146206_l()) break block9;
                    this.fieldList2.get(1).func_146195_b(false);
                    this.fieldList2.get(2).func_146195_b(true);
                    break block3;
                }
                if (!this.fieldList2.get(2).func_146206_l()) break block3;
                this.fieldList2.get(2).func_146195_b(false);
                this.fieldList.get(0).func_146195_b(true);
                break block3;
            }
            for (GuiTextNumeric text : this.fieldList) {
                value = text.func_146179_b();
                text.func_146201_a(typedChar, keyCode);
                if (value.equals(text.func_146179_b())) continue;
                c = new Color(this.getColotInt(0), this.getColotInt(1), this.getColotInt(2));
                this.setColorText(c);
            }
            for (GuiTextNumeric text : this.fieldList2) {
                value = text.func_146179_b();
                text.func_146201_a(typedChar, keyCode);
                if (value.equals(text.func_146179_b())) continue;
                c = new Color(this.getColotInt2(0), this.getColotInt2(1), this.getColotInt2(2));
                this.setColorBackground(c);
            }
        }
    }

    private int getColotInt(int id) {
        String text = this.fieldList.get(id).func_146179_b();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    private int getColotInt2(int id) {
        String text = this.fieldList2.get(id).func_146179_b();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(text);
    }
}

