/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.AddonsRegistry;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.Lock;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VolumeBox {
    public final World world;
    public UUID id;
    public Box box;
    private UUID player = null;
    private UUID oldPlayer = null;
    private BlockPos held = null;
    private double dist = 0.0;
    private BlockPos oldMin = null;
    private BlockPos oldMax = null;
    public final Map<EnumAddonSlot, Addon> addons = new EnumMap<EnumAddonSlot, Addon>(EnumAddonSlot.class);
    public final List<Lock> locks = new ArrayList<Lock>();

    public VolumeBox(World world, BlockPos at) {
        if (world == null) {
            throw new NullPointerException("world");
        }
        this.world = world;
        this.id = UUID.randomUUID();
        this.box = new Box(at, at);
    }

    public VolumeBox(World world, NBTTagCompound nbt) {
        if (world == null) {
            throw new NullPointerException("world");
        }
        this.world = world;
        this.id = nbt.func_186857_a("id");
        this.box = new Box();
        this.box.initialize(nbt.func_74775_l("box"));
        this.player = nbt.func_74764_b("player") ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("player")) : null;
        UUID uUID = this.oldPlayer = nbt.func_74764_b("oldPlayer") ? NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("oldPlayer")) : null;
        if (nbt.func_74764_b("held")) {
            this.held = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("held"));
        }
        this.dist = nbt.func_74769_h("dist");
        if (nbt.func_74764_b("oldMin")) {
            this.oldMin = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("oldMin"));
        }
        if (nbt.func_74764_b("oldMax")) {
            this.oldMax = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("oldMax"));
        }
        NBTUtilBC.readCompoundList(nbt.func_74781_a("addons")).forEach(addonsEntryTag -> {
            Class<? extends Addon> addonClass = AddonsRegistry.INSTANCE.getClassByName(new ResourceLocation(addonsEntryTag.func_74779_i("addonClass")));
            try {
                Addon addon = addonClass.newInstance();
                addon.volumeBox = this;
                addon.readFromNBT(addonsEntryTag.func_74775_l("addonData"));
                EnumAddonSlot slot = NBTUtilBC.readEnum(addonsEntryTag.func_74781_a("slot"), EnumAddonSlot.class);
                this.addons.put(slot, addon);
                addon.postReadFromNbt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        NBTUtilBC.readCompoundList(nbt.func_74781_a("locks")).map(lockTag -> {
            Lock lock = new Lock();
            lock.readFromNBT((NBTTagCompound)lockTag);
            return lock;
        }).forEach(this.locks::add);
    }

    public VolumeBox(World world, PacketBufferBC buf) throws IOException {
        if (world == null) {
            throw new NullPointerException("world");
        }
        this.world = world;
        this.fromBytes(buf);
    }

    public boolean isEditing() {
        return this.player != null;
    }

    private void resetEditing() {
        this.oldMax = null;
        this.oldMin = null;
        this.held = null;
        this.dist = 0.0;
    }

    public void cancelEditing() {
        this.player = null;
        this.box.reset();
        this.box.extendToEncompass(this.oldMin);
        this.box.extendToEncompass(this.oldMax);
        this.resetEditing();
    }

    public void confirmEditing() {
        this.player = null;
        this.resetEditing();
        this.addons.values().forEach(Addon::onVolumeBoxSizeChange);
    }

    public void pauseEditing() {
        this.oldPlayer = this.player;
        this.player = null;
    }

    public void resumeEditing() {
        this.player = this.oldPlayer;
        this.oldPlayer = null;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player.func_146103_bH().getId();
    }

    public boolean isEditingBy(EntityPlayer player) {
        return player != null && Objects.equals(this.player, player.func_146103_bH().getId());
    }

    public boolean isPausedEditingBy(EntityPlayer player) {
        return this.oldPlayer != null && Objects.equals(this.oldPlayer, player.func_146103_bH().getId());
    }

    public EntityPlayer getPlayer(World world) {
        return world.func_152378_a(this.player);
    }

    public void setHeldDistOldMinOldMax(BlockPos held, double dist, BlockPos oldMin, BlockPos oldMax) {
        this.held = held;
        this.dist = dist;
        this.oldMin = oldMin;
        this.oldMax = oldMax;
    }

    public BlockPos getHeld() {
        return this.held;
    }

    public double getDist() {
        return this.dist;
    }

    public Stream<Lock.Target> getLockTargetsStream() {
        return this.locks.stream().flatMap(lock -> lock.targets.stream());
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_186854_a("id", this.id);
        nbt.func_74782_a("box", (NBTBase)this.box.writeToNBT());
        if (this.player != null) {
            nbt.func_74782_a("player", (NBTBase)NBTUtil.func_186862_a((UUID)this.player));
        }
        if (this.oldPlayer != null) {
            nbt.func_74782_a("oldPlayer", (NBTBase)NBTUtil.func_186862_a((UUID)this.oldPlayer));
        }
        if (this.held != null) {
            nbt.func_74782_a("held", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.held));
        }
        nbt.func_74780_a("dist", this.dist);
        if (this.oldMin != null) {
            nbt.func_74782_a("oldMin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.oldMin));
        }
        if (this.oldMax != null) {
            nbt.func_74782_a("oldMax", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.oldMax));
        }
        nbt.func_74782_a("addons", (NBTBase)NBTUtilBC.writeCompoundList(this.addons.entrySet().stream().map(entry -> {
            NBTTagCompound addonsEntryTag = new NBTTagCompound();
            addonsEntryTag.func_74782_a("slot", NBTUtilBC.writeEnum((Enum)entry.getKey()));
            addonsEntryTag.func_74778_a("addonClass", AddonsRegistry.INSTANCE.getNameByClass(((Addon)entry.getValue()).getClass()).toString());
            addonsEntryTag.func_74782_a("addonData", (NBTBase)((Addon)entry.getValue()).writeToNBT(new NBTTagCompound()));
            return addonsEntryTag;
        })));
        nbt.func_74782_a("locks", (NBTBase)NBTUtilBC.writeCompoundList(this.locks.stream().map(Lock::writeToNBT)));
        return nbt;
    }

    public void toBytes(PacketBufferBC buf) {
        buf.func_179252_a(this.id);
        this.box.writeData(buf);
        buf.writeBoolean(this.player != null);
        if (this.player != null) {
            buf.func_179252_a(this.player);
        }
        buf.writeInt(this.addons.size());
        this.addons.forEach((slot, addon) -> {
            buf.writeEnumValue((Enum<?>)slot);
            buf.func_180714_a(AddonsRegistry.INSTANCE.getNameByClass(addon.getClass()).toString());
            addon.toBytes(buf);
        });
        buf.writeInt(this.locks.size());
        this.locks.forEach(lock -> lock.toBytes(buf));
    }

    public void fromBytes(PacketBufferBC buf) throws IOException {
        this.id = buf.func_179253_g();
        this.box = new Box();
        this.box.readData(buf);
        this.player = buf.readBoolean() ? buf.func_179253_g() : null;
        EnumMap<EnumAddonSlot, Addon> newAddons = new EnumMap<EnumAddonSlot, Addon>(EnumAddonSlot.class);
        int count = buf.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            EnumAddonSlot slot2 = buf.func_179257_a(EnumAddonSlot.class);
            ResourceLocation rl = new ResourceLocation(buf.func_150789_c(1024));
            Class<? extends Addon> addonClass = AddonsRegistry.INSTANCE.getClassByName(rl);
            try {
                if (addonClass == null) {
                    throw new IOException("Unknown addon class " + rl);
                }
                Addon addon = addonClass.newInstance();
                addon.volumeBox = this;
                addon.onAdded();
                addon.fromBytes(buf);
                newAddons.put(slot2, addon);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IOException("Failed to deserialize addon!", e);
            }
        }
        this.addons.keySet().removeIf(slot -> !newAddons.containsKey(slot));
        newAddons.entrySet().stream().filter(slotAddon -> !this.addons.containsKey(slotAddon.getKey())).forEach(slotAddon -> this.addons.put((EnumAddonSlot)((Object)((Object)slotAddon.getKey())), (Addon)slotAddon.getValue()));
        for (Map.Entry slotAddon2 : newAddons.entrySet()) {
            PacketBufferBC buffer = new PacketBufferBC(Unpooled.buffer());
            ((Addon)slotAddon2.getValue()).toBytes(buffer);
            this.addons.get(slotAddon2.getKey()).fromBytes(buffer);
        }
        this.locks.clear();
        IntStream.range(0, buf.readInt()).mapToObj(i -> {
            Lock lock = new Lock();
            lock.fromBytes(buf);
            return lock;
        }).forEach(this.locks::add);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.id.equals(((VolumeBox)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

