/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.model;

import buildcraft.factory.BCFactoryModels;
import buildcraft.factory.block.BlockHeatExchange;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class ModelHeatExchange
extends ModelItemSimple {
    public static final NodeType<BlockHeatExchange.EnumExchangePart> TYPE_EXCHANGE_PART = new NodeType<BlockHeatExchange.EnumExchangePart>("HeatExchangePart", BlockHeatExchange.EnumExchangePart.MIDDLE);
    public static final FunctionContext FUNCTION_CONTEXT;
    public static final NodeVariableBoolean VAR_CONNECTED_LEFT;
    public static final NodeVariableBoolean VAR_CONNECTED_RIGHT;
    public static final NodeVariableBoolean VAR_CONNECTED_UP;
    public static final NodeVariableBoolean VAR_CONNECTED_DOWN;
    public static final NodeVariableObject<BlockHeatExchange.EnumExchangePart> VAR_PART;
    public static final NodeVariableObject<EnumFacing> VAR_DIRECTION;
    private final TextureAtlasSprite particle;
    private final List<List<BakedQuad>> cache = new ArrayList<List<BakedQuad>>();

    public ModelHeatExchange() {
        super((List<BakedQuad>)ImmutableList.of(), TRANSFORM_BLOCK, false);
        ModelHeatExchange.VAR_CONNECTED_DOWN.value = false;
        ModelHeatExchange.VAR_CONNECTED_UP.value = false;
        ModelHeatExchange.VAR_CONNECTED_LEFT.value = false;
        ModelHeatExchange.VAR_CONNECTED_RIGHT.value = false;
        ModelHeatExchange.VAR_PART.value = BlockHeatExchange.EnumExchangePart.MIDDLE;
        ModelHeatExchange.VAR_DIRECTION.value = EnumFacing.NORTH;
        this.particle = BCFactoryModels.HEAT_EXCHANGE_STATIC.getCutoutQuads().length == 0 ? Minecraft.func_71410_x().func_147117_R().func_174944_f() : BCFactoryModels.HEAT_EXCHANGE_STATIC.getCutoutQuads()[0].toBakedItem().func_187508_a();
        for (int i = 0; i < 96; ++i) {
            boolean connectedUpDown = (i & 4) == 4;
            BlockHeatExchange.EnumExchangePart part = BlockHeatExchange.EnumExchangePart.values()[i / 32];
            ModelHeatExchange.VAR_CONNECTED_LEFT.value = (i & 1) == 1;
            ModelHeatExchange.VAR_CONNECTED_RIGHT.value = (i & 2) == 2;
            ModelHeatExchange.VAR_CONNECTED_UP.value = connectedUpDown && part == BlockHeatExchange.EnumExchangePart.END;
            ModelHeatExchange.VAR_CONNECTED_DOWN.value = connectedUpDown && part == BlockHeatExchange.EnumExchangePart.START;
            ModelHeatExchange.VAR_PART.value = part;
            ModelHeatExchange.VAR_DIRECTION.value = EnumFacing.func_176731_b((int)(i / 8 & 3));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (MutableQuad quad : BCFactoryModels.HEAT_EXCHANGE_STATIC.getCutoutQuads()) {
                quad.multShade();
                quads.add(quad.toBakedBlock());
            }
            this.cache.add(quads);
        }
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        return this.cache.get(ModelHeatExchange.getIndexOf(state));
    }

    private static int getIndexOf(IBlockState state) {
        return ((Boolean)state.func_177229_b(BlockHeatExchange.PROP_CONNECTED_LEFT) != false ? 1 : 0) | ((Boolean)state.func_177229_b(BlockHeatExchange.PROP_CONNECTED_RIGHT) != false ? 2 : 0) | ((Boolean)state.func_177229_b(BlockHeatExchange.PROP_CONNECTED_Y) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176736_b() * 8 | ((BlockHeatExchange.EnumExchangePart)((Object)state.func_177229_b(BlockHeatExchange.PROP_PART))).ordinal() * 8 * 4;
    }

    static {
        NodeTypes.addType(TYPE_EXCHANGE_PART);
        for (BlockHeatExchange.EnumExchangePart part : BlockHeatExchange.EnumExchangePart.values()) {
            TYPE_EXCHANGE_PART.putConstant(part.func_176610_l(), part);
        }
        FUNCTION_CONTEXT = new FunctionContext("heat_exchange", DefaultContexts.createWithAll(), TYPE_EXCHANGE_PART);
        VAR_CONNECTED_LEFT = FUNCTION_CONTEXT.putVariableBoolean("connected_left");
        VAR_CONNECTED_RIGHT = FUNCTION_CONTEXT.putVariableBoolean("connected_right");
        VAR_CONNECTED_UP = FUNCTION_CONTEXT.putVariableBoolean("connected_up");
        VAR_CONNECTED_DOWN = FUNCTION_CONTEXT.putVariableBoolean("connected_down");
        VAR_PART = FUNCTION_CONTEXT.putVariableObject("part", BlockHeatExchange.EnumExchangePart.class);
        VAR_DIRECTION = FUNCTION_CONTEXT.putVariableObject("direction", EnumFacing.class);
    }
}

