/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.arch;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kr.pe.ecmaxp.openpython.arch.OpenPythonFirmware;
import kr.pe.ecmaxp.openpython.arch.OpenPythonVirtualMachine;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.driver.item.Memory;
import li.cil.oc.api.machine.Architecture;
import li.cil.oc.api.machine.ExecutionResult;
import li.cil.oc.api.machine.Machine;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001aH\u0016J\u0016\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001cH\u0016J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u001cH\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lkr/pe/ecmaxp/openpython/arch/OpenPythonArchitecture;", "Lli/cil/oc/api/machine/Architecture;", "machine", "Lli/cil/oc/api/machine/Machine;", "(Lli/cil/oc/api/machine/Machine;)V", "lastSynchronizedResult", "Lli/cil/oc/api/machine/ExecutionResult;", "getLastSynchronizedResult", "()Lli/cil/oc/api/machine/ExecutionResult;", "setLastSynchronizedResult", "(Lli/cil/oc/api/machine/ExecutionResult;)V", "getMachine", "()Lli/cil/oc/api/machine/Machine;", "totalMemory", "", "getTotalMemory", "()I", "setTotalMemory", "(I)V", "vm", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;", "getVm", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;", "setVm", "(Lkr/pe/ecmaxp/openpython/arch/OpenPythonVirtualMachine;)V", "close", "", "initialize", "", "isInitialized", "load", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onConnect", "onSignal", "recomputeMemory", "iterable", "", "Lnet/minecraft/item/ItemStack;", "runSynchronized", "runThreaded", "synchronizedReturn", "save", "step", "isSynchronized", "OpenPython"})
public class OpenPythonArchitecture
implements Architecture {
    private int totalMemory;
    @Nullable
    private OpenPythonVirtualMachine vm;
    @Nullable
    private ExecutionResult lastSynchronizedResult;
    @NotNull
    private final Machine machine;

    public final int getTotalMemory() {
        return this.totalMemory;
    }

    public final void setTotalMemory(int n) {
        this.totalMemory = n;
    }

    @Nullable
    public final OpenPythonVirtualMachine getVm() {
        return this.vm;
    }

    public final void setVm(@Nullable OpenPythonVirtualMachine openPythonVirtualMachine) {
        this.vm = openPythonVirtualMachine;
    }

    @Nullable
    public final ExecutionResult getLastSynchronizedResult() {
        return this.lastSynchronizedResult;
    }

    public final void setLastSynchronizedResult(@Nullable ExecutionResult executionResult) {
        this.lastSynchronizedResult = executionResult;
    }

    public boolean isInitialized() {
        return this.vm != null;
    }

    public boolean initialize() {
        this.close();
        try {
            OpenPythonFirmware firmware = OpenPythonFirmware.Companion.getV1_0_1();
            Iterable iterable = this.machine.host().internalComponents();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"machine.host().internalComponents()");
            this.recomputeMemory(iterable);
            this.vm = new OpenPythonVirtualMachine(this.machine, this.totalMemory, firmware);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.isInitialized();
    }

    public void close() {
        OpenPythonVirtualMachine openPythonVirtualMachine = this.vm;
        if (openPythonVirtualMachine != null) {
            openPythonVirtualMachine.close();
        }
        this.vm = null;
        this.lastSynchronizedResult = null;
    }

    public boolean recomputeMemory(@NotNull Iterable<ItemStack> iterable) {
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        double totalRam = 0.0;
        for (ItemStack stack : iterable) {
            DriverItem driver = Driver.driverFor((ItemStack)stack);
            if (!(driver instanceof Memory)) continue;
            totalRam += ((Memory)driver).amount(stack) * (double)1024;
        }
        this.totalMemory = (int)totalRam;
        OpenPythonVirtualMachine openPythonVirtualMachine = this.vm;
        return (double)(openPythonVirtualMachine != null ? openPythonVirtualMachine.getMemorySize() : 1) <= totalRam;
    }

    private final ExecutionResult step(boolean isSynchronized) {
        ExecutionResult executionResult;
        OpenPythonVirtualMachine openPythonVirtualMachine = this.vm;
        if (openPythonVirtualMachine == null) {
            return (ExecutionResult)new ExecutionResult.Error("invalid machine");
        }
        OpenPythonVirtualMachine vm = openPythonVirtualMachine;
        if (vm.getMemorySize() > this.totalMemory) {
            return (ExecutionResult)new ExecutionResult.Error("not enough memory");
        }
        try {
            executionResult = vm.step(isSynchronized);
        }
        catch (Exception e) {
            e.printStackTrace();
            executionResult = (ExecutionResult)new ExecutionResult.Error("kernel panic:\n" + e);
        }
        catch (Error e) {
            e.printStackTrace();
            executionResult = (ExecutionResult)new ExecutionResult.Error("kernel panic:\n" + e);
        }
        catch (Throwable e) {
            throw e;
        }
        return executionResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ExecutionResult runThreaded(boolean synchronizedReturn) {
        ExecutionResult executionResult;
        if (!synchronizedReturn) {
            executionResult = this.step(false);
        } else {
            void var2_2;
            ExecutionResult executionResult2 = this.lastSynchronizedResult;
            if (executionResult2 == null) {
                executionResult2 = (ExecutionResult)new ExecutionResult.SynchronizedCall();
            }
            ExecutionResult result = executionResult2;
            this.lastSynchronizedResult = null;
            executionResult = var2_2;
        }
        return executionResult;
    }

    public void runSynchronized() {
        this.lastSynchronizedResult = this.step(true);
    }

    public void onSignal() {
    }

    public void onConnect() {
    }

    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        if (!this.machine.isRunning()) {
            return;
        }
        OpenPythonVirtualMachine openPythonVirtualMachine = this.vm;
        if (openPythonVirtualMachine == null) {
            Intrinsics.throwNpe();
        }
        openPythonVirtualMachine.load(nbt);
    }

    public void save(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        OpenPythonVirtualMachine openPythonVirtualMachine = this.vm;
        if (openPythonVirtualMachine == null) {
            Intrinsics.throwNpe();
        }
        openPythonVirtualMachine.save(nbt);
    }

    @NotNull
    public final Machine getMachine() {
        return this.machine;
    }

    public OpenPythonArchitecture(@NotNull Machine machine) {
        Intrinsics.checkParameterIsNotNull((Object)machine, (String)"machine");
        this.machine = machine;
    }
}

