/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.arch;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kr.pe.ecmaxp.openpython.arch.OpenPythonFirmware;
import kr.pe.ecmaxp.openpython.arch.types.Entry;
import kr.pe.ecmaxp.thumbsf.CPU;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "path", "protocol", "", "getProtocol", "()I", "findTarget", "Lkr/pe/ecmaxp/openpython/arch/types/Entry;", "address", "getResource", "Ljava/net/URL;", "filename", "loadEEPROM", "", "loadFirmware", "loadMapping", "", "printLastTracebackCPU", "", "cpu", "Lkr/pe/ecmaxp/thumbsf/CPU;", "Companion", "OpenPython"})
public final class OpenPythonFirmware {
    private final int protocol = 1;
    private final String path;
    @NotNull
    private final String name;
    @NotNull
    private static final OpenPythonFirmware v1_0_1;
    public static final Companion Companion;

    public final int getProtocol() {
        return this.protocol;
    }

    private final URL getResource(String filename) {
        URL uRL = OpenPythonFirmware.class.getResource(this.path + '/' + filename);
        if (uRL == null) {
            Intrinsics.throwNpe();
        }
        return uRL;
    }

    @NotNull
    public final byte[] loadFirmware() {
        URL firmware = this.getResource("firmware.bin");
        return TextStreamsKt.readBytes((URL)firmware);
    }

    @NotNull
    public final byte[] loadEEPROM() {
        URL eeprom = this.getResource("eeprom.py");
        return TextStreamsKt.readBytes((URL)eeprom);
    }

    @NotNull
    public final List<Entry> loadMapping() {
        URL file;
        URL uRL = file = this.getResource("firmware.map");
        Charset charset = Charsets.UTF_8;
        Object object = TextStreamsKt.readBytes((URL)uRL);
        List lines = StringsKt.lines((CharSequence)new String((byte[])object, charset));
        ArrayList<Entry> result = new ArrayList<Entry>();
        loadMapping.1 parseHex$ = loadMapping.1.INSTANCE;
        object = lines.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            CharSequence charSequence = line;
            if (charSequence.length() == 0) continue;
            List tokens = StringsKt.split$default((CharSequence)line, (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null);
            if (tokens.size() != 4) {
                throw (Throwable)new Exception("Invalid Map File");
            }
            int address = parseHex$.invoke((String)tokens.get(0));
            int size = parseHex$.invoke((String)tokens.get(1));
            String type = (String)tokens.get(2);
            String name = (String)tokens.get(3);
            Entry target = new Entry(address, size, type, name);
            result.add(target);
        }
        return result;
    }

    @Nullable
    public final Entry findTarget(int address) {
        List<Entry> mapping = this.loadMapping();
        Entry selected = null;
        for (Entry target : CollectionsKt.reversed((Iterable)mapping)) {
            if (target.getAddress() > address) continue;
            selected = target;
            break;
        }
        return selected;
    }

    public final void printLastTracebackCPU(@NotNull CPU cpu) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)cpu, (String)"cpu");
        Entry selected = this.findTarget(cpu.getRegs().getPc());
        if (selected != null) {
            string = "PC: " + selected.getName() + " (+" + (cpu.getRegs().getPc() - selected.getAddress()) + ")\t";
            System.out.print((Object)string);
        } else {
            string = "PC: (null) (" + cpu.getRegs().getPc() + ")\t";
            System.out.print((Object)string);
        }
        selected = this.findTarget(cpu.getRegs().getLr());
        if (selected != null) {
            string = "LR:" + selected.getName() + " (+" + (cpu.getRegs().getLr() - selected.getAddress()) + ')';
            System.out.print((Object)string);
        } else {
            string = "LR: (null) (" + cpu.getRegs().getLr() + ')';
            System.out.print((Object)string);
        }
        char c = '\n';
        System.out.print(c);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public OpenPythonFirmware(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.protocol = 1;
        this.path = "/assets/openpython/firmwares/" + this.name;
        if (StringsKt.indexOf$default((CharSequence)this.name, (char)'/', (int)0, (boolean)false, (int)6, null) >= 0) {
            throw (Throwable)new Exception("Invalid Filename");
        }
        this.getResource("firmware.bin");
    }

    static {
        Companion = new Companion(null);
        v1_0_1 = new OpenPythonFirmware("v1.0.1");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware$Companion;", "", "()V", "v1_0_1", "Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;", "getV1_0_1", "()Lkr/pe/ecmaxp/openpython/arch/OpenPythonFirmware;", "OpenPython"})
    public static final class Companion {
        @NotNull
        public final OpenPythonFirmware getV1_0_1() {
            return v1_0_1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

