/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.arch.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kr.pe.ecmaxp.openpython.arch.state.ValueContainer;
import li.cil.oc.api.Persistable;
import li.cil.oc.api.machine.Value;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0011\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fH\u0086\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0014J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010\u00a8\u0006#"}, d2={"Lkr/pe/ecmaxp/openpython/arch/state/ValueContainerMap;", "Lli/cil/oc/api/Persistable;", "()V", "containerSet", "Ljava/util/HashSet;", "Lkr/pe/ecmaxp/openpython/arch/state/ValueContainer;", "getContainerSet", "()Ljava/util/HashSet;", "setContainerSet", "(Ljava/util/HashSet;)V", "pointerMap", "Ljava/util/HashMap;", "", "getPointerMap", "()Ljava/util/HashMap;", "setPointerMap", "(Ljava/util/HashMap;)V", "rand", "Ljava/util/Random;", "valueMap", "Lli/cil/oc/api/machine/Value;", "getValueMap", "setValueMap", "findEmptyId", "get", "id", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "register", "value", "save", "unregister", "container", "OpenPython"})
public final class ValueContainerMap
implements Persistable {
    @NotNull
    private HashSet<ValueContainer> containerSet = new HashSet();
    @NotNull
    private HashMap<Integer, ValueContainer> pointerMap = new HashMap();
    @NotNull
    private HashMap<Value, ValueContainer> valueMap = new HashMap();
    private final Random rand = new Random();

    @NotNull
    public final HashSet<ValueContainer> getContainerSet() {
        return this.containerSet;
    }

    public final void setContainerSet(@NotNull HashSet<ValueContainer> hashSet) {
        Intrinsics.checkParameterIsNotNull(hashSet, (String)"<set-?>");
        this.containerSet = hashSet;
    }

    @NotNull
    public final HashMap<Integer, ValueContainer> getPointerMap() {
        return this.pointerMap;
    }

    public final void setPointerMap(@NotNull HashMap<Integer, ValueContainer> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.pointerMap = hashMap;
    }

    @NotNull
    public final HashMap<Value, ValueContainer> getValueMap() {
        return this.valueMap;
    }

    public final void setValueMap(@NotNull HashMap<Value, ValueContainer> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.valueMap = hashMap;
    }

    @NotNull
    public final Value get(int id) {
        ValueContainer valueContainer = this.pointerMap.get(id);
        if (valueContainer == null) {
            Intrinsics.throwNpe();
        }
        Value value = valueContainer.getValue();
        if (value == null) {
            Intrinsics.throwNpe();
        }
        return value;
    }

    @NotNull
    public final ValueContainer register(@NotNull Value value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ValueContainer valueContainer = this.valueMap.get(value);
        if (valueContainer == null) {
            valueContainer = this.register(this.findEmptyId(), value);
        }
        return valueContainer;
    }

    @NotNull
    public final ValueContainer register(int id, @NotNull Value value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ValueContainer container = new ValueContainer(value, id);
        Map map = this.valueMap;
        Object object = container;
        map.put(value, object);
        map = this.pointerMap;
        object = id;
        ValueContainer valueContainer = container;
        map.put(object, valueContainer);
        this.containerSet.add(container);
        return container;
    }

    public final void unregister(@NotNull Value value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ValueContainer valueContainer = this.valueMap.get(value);
        if (valueContainer == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)valueContainer, (String)"valueMap[value]!!");
        this.unregister(valueContainer);
    }

    public final void unregister(@NotNull ValueContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Map map = this.valueMap;
        Value value = container.getValue();
        Map map2 = map;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        TypeIntrinsics.asMutableMap((Object)map2).remove(value);
        this.pointerMap.remove(container.getId());
        this.containerSet.remove(container);
    }

    private final int findEmptyId() {
        PrimitiveIterator.OfInt ofInt = this.rand.ints().iterator();
        while (ofInt.hasNext()) {
            Integer num = ofInt.next();
            if (this.pointerMap.containsKey(num)) continue;
            Integer n = num;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"num");
            return n;
        }
        return 0;
    }

    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        NBTTagList tagList = nbt.func_150295_c("list", (int)new NBTTagCompound().func_74732_a());
        Iterator iterator = tagList.iterator();
        while (iterator.hasNext()) {
            NBTBase containerBaseTag;
            NBTBase nBTBase = containerBaseTag = (NBTBase)iterator.next();
            if (nBTBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound containerTag = (NBTTagCompound)nBTBase;
            ValueContainer container = new ValueContainer(null, 0, 3, null);
            container.load(containerTag);
            int n = container.getId();
            Value value = container.getValue();
            if (value == null) {
                Intrinsics.throwNpe();
            }
            this.register(n, value);
        }
    }

    public void save(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        NBTTagList tagList = new NBTTagList();
        for (ValueContainer container : this.containerSet) {
            NBTTagCompound containerTag = new NBTTagCompound();
            container.save(containerTag);
            tagList.func_74742_a((NBTBase)containerTag);
        }
        nbt.func_74782_a("list", (NBTBase)tagList);
    }
}

