/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.core;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.ExtensionTypeHeader;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageFormat;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageFormatException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageInsufficientBufferException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageIntegerOverflowException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageNeverUsedFormatException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessagePack;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessagePackException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageSizeException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageStringCodingException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageTypeException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.Preconditions;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBuffer;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBufferInput;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.Value;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ValueFactory;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.Variable;

public class MessageUnpacker
implements Closeable {
    private static final MessageBuffer EMPTY_BUFFER = MessageBuffer.wrap(new byte[0]);
    private final boolean allowReadingStringAsBinary;
    private final boolean allowReadingBinaryAsString;
    private final CodingErrorAction actionOnMalformedString;
    private final CodingErrorAction actionOnUnmappableString;
    private final int stringSizeLimit;
    private final int stringDecoderBufferSize;
    private MessageBufferInput in;
    private MessageBuffer buffer = EMPTY_BUFFER;
    private int position;
    private long totalReadBytes;
    private final MessageBuffer numberBuffer = MessageBuffer.allocate(8);
    private int nextReadPosition;
    private StringBuilder decodeStringBuffer;
    private CharsetDecoder decoder;
    private CharBuffer decodeBuffer;
    private static final String EMPTY_STRING = "";

    protected MessageUnpacker(MessageBufferInput in, MessagePack.UnpackerConfig config) {
        this.in = Preconditions.checkNotNull(in, "MessageBufferInput is null");
        this.allowReadingStringAsBinary = config.getAllowReadingStringAsBinary();
        this.allowReadingBinaryAsString = config.getAllowReadingBinaryAsString();
        this.actionOnMalformedString = config.getActionOnMalformedString();
        this.actionOnUnmappableString = config.getActionOnUnmappableString();
        this.stringSizeLimit = config.getStringSizeLimit();
        this.stringDecoderBufferSize = config.getStringDecoderBufferSize();
    }

    public MessageBufferInput reset(MessageBufferInput in) throws IOException {
        MessageBufferInput newIn = Preconditions.checkNotNull(in, "MessageBufferInput is null");
        MessageBufferInput old = this.in;
        this.in = newIn;
        this.buffer = EMPTY_BUFFER;
        this.position = 0;
        this.totalReadBytes = 0L;
        return old;
    }

    public long getTotalReadBytes() {
        return this.totalReadBytes + (long)this.position;
    }

    private MessageBuffer getNextBuffer() throws IOException {
        MessageBuffer next = this.in.next();
        if (next == null) {
            throw new MessageInsufficientBufferException();
        }
        assert (this.buffer != null);
        this.totalReadBytes += (long)this.buffer.size();
        return next;
    }

    private void nextBuffer() throws IOException {
        this.buffer = this.getNextBuffer();
        this.position = 0;
    }

    private MessageBuffer prepareNumberBuffer(int readLength) throws IOException {
        int remaining = this.buffer.size() - this.position;
        if (remaining >= readLength) {
            this.nextReadPosition = this.position;
            this.position += readLength;
            return this.buffer;
        }
        int off = 0;
        if (remaining > 0) {
            this.numberBuffer.putMessageBuffer(0, this.buffer, this.position, remaining);
            readLength -= remaining;
            off += remaining;
        }
        while (true) {
            this.nextBuffer();
            int nextSize = this.buffer.size();
            if (nextSize >= readLength) break;
            this.numberBuffer.putMessageBuffer(off, this.buffer, 0, nextSize);
            readLength -= nextSize;
            off += nextSize;
        }
        this.numberBuffer.putMessageBuffer(off, this.buffer, 0, readLength);
        this.position = readLength;
        this.nextReadPosition = 0;
        return this.numberBuffer;
    }

    private static int utf8MultibyteCharacterSize(byte firstByte) {
        return Integer.numberOfLeadingZeros(~(firstByte & 0xFF) << 24);
    }

    public boolean hasNext() throws IOException {
        return this.ensureBuffer();
    }

    private boolean ensureBuffer() throws IOException {
        while (this.buffer.size() <= this.position) {
            MessageBuffer next = this.in.next();
            if (next == null) {
                return false;
            }
            this.totalReadBytes += (long)this.buffer.size();
            this.buffer = next;
            this.position = 0;
        }
        return true;
    }

    public MessageFormat getNextFormat() throws IOException {
        if (!this.ensureBuffer()) {
            throw new MessageInsufficientBufferException();
        }
        byte b = this.buffer.getByte(this.position);
        return MessageFormat.valueOf(b);
    }

    private byte readByte() throws IOException {
        if (this.buffer.size() > this.position) {
            byte b = this.buffer.getByte(this.position);
            ++this.position;
            return b;
        }
        this.nextBuffer();
        if (this.buffer.size() > 0) {
            byte b = this.buffer.getByte(0);
            this.position = 1;
            return b;
        }
        return this.readByte();
    }

    private short readShort() throws IOException {
        MessageBuffer numberBuffer = this.prepareNumberBuffer(2);
        return numberBuffer.getShort(this.nextReadPosition);
    }

    private int readInt() throws IOException {
        MessageBuffer numberBuffer = this.prepareNumberBuffer(4);
        return numberBuffer.getInt(this.nextReadPosition);
    }

    private long readLong() throws IOException {
        MessageBuffer numberBuffer = this.prepareNumberBuffer(8);
        return numberBuffer.getLong(this.nextReadPosition);
    }

    private float readFloat() throws IOException {
        MessageBuffer numberBuffer = this.prepareNumberBuffer(4);
        return numberBuffer.getFloat(this.nextReadPosition);
    }

    private double readDouble() throws IOException {
        MessageBuffer numberBuffer = this.prepareNumberBuffer(8);
        return numberBuffer.getDouble(this.nextReadPosition);
    }

    public void skipValue() throws IOException {
        this.skipValue(1);
    }

    public void skipValue(int count) throws IOException {
        while (count > 0) {
            byte b = this.readByte();
            MessageFormat f = MessageFormat.valueOf(b);
            switch (f) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    break;
                }
                case FIXMAP: {
                    int mapLen = b & 0xF;
                    count += mapLen * 2;
                    break;
                }
                case FIXARRAY: {
                    int arrayLen = b & 0xF;
                    count += arrayLen;
                    break;
                }
                case FIXSTR: {
                    int strLen = b & 0x1F;
                    this.skipPayload(strLen);
                    break;
                }
                case INT8: 
                case UINT8: {
                    this.skipPayload(1);
                    break;
                }
                case INT16: 
                case UINT16: {
                    this.skipPayload(2);
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.skipPayload(4);
                    break;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.skipPayload(8);
                    break;
                }
                case BIN8: 
                case STR8: {
                    this.skipPayload(this.readNextLength8());
                    break;
                }
                case BIN16: 
                case STR16: {
                    this.skipPayload(this.readNextLength16());
                    break;
                }
                case BIN32: 
                case STR32: {
                    this.skipPayload(this.readNextLength32());
                    break;
                }
                case FIXEXT1: {
                    this.skipPayload(2);
                    break;
                }
                case FIXEXT2: {
                    this.skipPayload(3);
                    break;
                }
                case FIXEXT4: {
                    this.skipPayload(5);
                    break;
                }
                case FIXEXT8: {
                    this.skipPayload(9);
                    break;
                }
                case FIXEXT16: {
                    this.skipPayload(17);
                    break;
                }
                case EXT8: {
                    this.skipPayload(this.readNextLength8() + 1);
                    break;
                }
                case EXT16: {
                    this.skipPayload(this.readNextLength16() + 1);
                    break;
                }
                case EXT32: {
                    this.skipPayload(this.readNextLength32() + 1);
                    break;
                }
                case ARRAY16: {
                    count += this.readNextLength16();
                    break;
                }
                case ARRAY32: {
                    count += this.readNextLength32();
                    break;
                }
                case MAP16: {
                    count += this.readNextLength16() * 2;
                    break;
                }
                case MAP32: {
                    count += this.readNextLength32() * 2;
                    break;
                }
                case NEVER_USED: {
                    throw new MessageNeverUsedFormatException("Encountered 0xC1 \"NEVER_USED\" byte");
                }
            }
            --count;
        }
    }

    private static MessagePackException unexpected(String expected, byte b) {
        MessageFormat format = MessageFormat.valueOf(b);
        if (format == MessageFormat.NEVER_USED) {
            return new MessageNeverUsedFormatException(String.format("Expected %s, but encountered 0xC1 \"NEVER_USED\" byte", expected));
        }
        String name = format.getValueType().name();
        String typeName = name.substring(0, 1) + name.substring(1).toLowerCase();
        return new MessageTypeException(String.format("Expected %s, but got %s (%02x)", expected, typeName, b));
    }

    public ImmutableValue unpackValue() throws IOException {
        MessageFormat mf = this.getNextFormat();
        switch (mf.getValueType()) {
            case NIL: {
                this.readByte();
                return ValueFactory.newNil();
            }
            case BOOLEAN: {
                return ValueFactory.newBoolean(this.unpackBoolean());
            }
            case INTEGER: {
                if (mf == MessageFormat.UINT64) {
                    return ValueFactory.newInteger(this.unpackBigInteger());
                }
                return ValueFactory.newInteger(this.unpackLong());
            }
            case FLOAT: {
                return ValueFactory.newFloat(this.unpackDouble());
            }
            case STRING: {
                int length = this.unpackRawStringHeader();
                return ValueFactory.newString(this.readPayload(length), true);
            }
            case BINARY: {
                int length = this.unpackBinaryHeader();
                return ValueFactory.newBinary(this.readPayload(length), true);
            }
            case ARRAY: {
                int size = this.unpackArrayHeader();
                Value[] array = new Value[size];
                for (int i = 0; i < size; ++i) {
                    array[i] = this.unpackValue();
                }
                return ValueFactory.newArray(array, true);
            }
            case MAP: {
                int size = this.unpackMapHeader();
                Value[] kvs = new Value[size * 2];
                for (int i = 0; i < size * 2; ++i) {
                    kvs[i] = this.unpackValue();
                    kvs[++i] = this.unpackValue();
                }
                return ValueFactory.newMap(kvs, true);
            }
            case EXTENSION: {
                ExtensionTypeHeader extHeader = this.unpackExtensionTypeHeader();
                return ValueFactory.newExtension(extHeader.getType(), this.readPayload(extHeader.getLength()));
            }
        }
        throw new MessageNeverUsedFormatException("Unknown value type");
    }

    public Variable unpackValue(Variable var) throws IOException {
        MessageFormat mf = this.getNextFormat();
        switch (mf.getValueType()) {
            case NIL: {
                this.readByte();
                var.setNilValue();
                return var;
            }
            case BOOLEAN: {
                var.setBooleanValue(this.unpackBoolean());
                return var;
            }
            case INTEGER: {
                switch (mf) {
                    case UINT64: {
                        var.setIntegerValue(this.unpackBigInteger());
                        return var;
                    }
                }
                var.setIntegerValue(this.unpackLong());
                return var;
            }
            case FLOAT: {
                var.setFloatValue(this.unpackDouble());
                return var;
            }
            case STRING: {
                int length = this.unpackRawStringHeader();
                var.setStringValue(this.readPayload(length));
                return var;
            }
            case BINARY: {
                int length = this.unpackBinaryHeader();
                var.setBinaryValue(this.readPayload(length));
                return var;
            }
            case ARRAY: {
                int size = this.unpackArrayHeader();
                ArrayList<Value> list = new ArrayList<Value>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.unpackValue());
                }
                var.setArrayValue(list);
                return var;
            }
            case MAP: {
                int size = this.unpackMapHeader();
                HashMap<Value, Value> map = new HashMap<Value, Value>();
                for (int i = 0; i < size; ++i) {
                    ImmutableValue k = this.unpackValue();
                    ImmutableValue v = this.unpackValue();
                    map.put(k, v);
                }
                var.setMapValue(map);
                return var;
            }
            case EXTENSION: {
                ExtensionTypeHeader extHeader = this.unpackExtensionTypeHeader();
                var.setExtensionValue(extHeader.getType(), this.readPayload(extHeader.getLength()));
                return var;
            }
        }
        throw new MessageFormatException("Unknown value type");
    }

    public void unpackNil() throws IOException {
        byte b = this.readByte();
        if (b == -64) {
            return;
        }
        throw MessageUnpacker.unexpected("Nil", b);
    }

    public boolean tryUnpackNil() throws IOException {
        if (!this.ensureBuffer()) {
            throw new MessageInsufficientBufferException();
        }
        byte b = this.buffer.getByte(this.position);
        if (b == -64) {
            this.readByte();
            return true;
        }
        return false;
    }

    public boolean unpackBoolean() throws IOException {
        byte b = this.readByte();
        if (b == -62) {
            return false;
        }
        if (b == -61) {
            return true;
        }
        throw MessageUnpacker.unexpected("boolean", b);
    }

    public byte unpackByte() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixInt(b)) {
            return b;
        }
        switch (b) {
            case -52: {
                byte u8 = this.readByte();
                if (u8 < 0) {
                    throw MessageUnpacker.overflowU8(u8);
                }
                return u8;
            }
            case -51: {
                short u16 = this.readShort();
                if (u16 < 0 || u16 > 127) {
                    throw MessageUnpacker.overflowU16(u16);
                }
                return (byte)u16;
            }
            case -50: {
                int u32 = this.readInt();
                if (u32 < 0 || u32 > 127) {
                    throw MessageUnpacker.overflowU32(u32);
                }
                return (byte)u32;
            }
            case -49: {
                long u64 = this.readLong();
                if (u64 < 0L || u64 > 127L) {
                    throw MessageUnpacker.overflowU64(u64);
                }
                return (byte)u64;
            }
            case -48: {
                byte i8 = this.readByte();
                return i8;
            }
            case -47: {
                short i16 = this.readShort();
                if (i16 < -128 || i16 > 127) {
                    throw MessageUnpacker.overflowI16(i16);
                }
                return (byte)i16;
            }
            case -46: {
                int i32 = this.readInt();
                if (i32 < -128 || i32 > 127) {
                    throw MessageUnpacker.overflowI32(i32);
                }
                return (byte)i32;
            }
            case -45: {
                long i64 = this.readLong();
                if (i64 < -128L || i64 > 127L) {
                    throw MessageUnpacker.overflowI64(i64);
                }
                return (byte)i64;
            }
        }
        throw MessageUnpacker.unexpected("Integer", b);
    }

    public short unpackShort() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixInt(b)) {
            return b;
        }
        switch (b) {
            case -52: {
                byte u8 = this.readByte();
                return (short)(u8 & 0xFF);
            }
            case -51: {
                short u16 = this.readShort();
                if (u16 < 0) {
                    throw MessageUnpacker.overflowU16(u16);
                }
                return u16;
            }
            case -50: {
                int u32 = this.readInt();
                if (u32 < 0 || u32 > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowU32(u32);
                }
                return (short)u32;
            }
            case -49: {
                long u64 = this.readLong();
                if (u64 < 0L || u64 > 32767L) {
                    throw MessageUnpacker.overflowU64(u64);
                }
                return (short)u64;
            }
            case -48: {
                byte i8 = this.readByte();
                return i8;
            }
            case -47: {
                short i16 = this.readShort();
                return i16;
            }
            case -46: {
                int i32 = this.readInt();
                if (i32 < Short.MIN_VALUE || i32 > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowI32(i32);
                }
                return (short)i32;
            }
            case -45: {
                long i64 = this.readLong();
                if (i64 < -32768L || i64 > 32767L) {
                    throw MessageUnpacker.overflowI64(i64);
                }
                return (short)i64;
            }
        }
        throw MessageUnpacker.unexpected("Integer", b);
    }

    public int unpackInt() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixInt(b)) {
            return b;
        }
        switch (b) {
            case -52: {
                byte u8 = this.readByte();
                return u8 & 0xFF;
            }
            case -51: {
                short u16 = this.readShort();
                return u16 & 0xFFFF;
            }
            case -50: {
                int u32 = this.readInt();
                if (u32 < 0) {
                    throw MessageUnpacker.overflowU32(u32);
                }
                return u32;
            }
            case -49: {
                long u64 = this.readLong();
                if (u64 < 0L || u64 > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowU64(u64);
                }
                return (int)u64;
            }
            case -48: {
                byte i8 = this.readByte();
                return i8;
            }
            case -47: {
                short i16 = this.readShort();
                return i16;
            }
            case -46: {
                int i32 = this.readInt();
                return i32;
            }
            case -45: {
                long i64 = this.readLong();
                if (i64 < Integer.MIN_VALUE || i64 > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowI64(i64);
                }
                return (int)i64;
            }
        }
        throw MessageUnpacker.unexpected("Integer", b);
    }

    public long unpackLong() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixInt(b)) {
            return b;
        }
        switch (b) {
            case -52: {
                byte u8 = this.readByte();
                return u8 & 0xFF;
            }
            case -51: {
                short u16 = this.readShort();
                return u16 & 0xFFFF;
            }
            case -50: {
                int u32 = this.readInt();
                if (u32 < 0) {
                    return (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
                }
                return u32;
            }
            case -49: {
                long u64 = this.readLong();
                if (u64 < 0L) {
                    throw MessageUnpacker.overflowU64(u64);
                }
                return u64;
            }
            case -48: {
                byte i8 = this.readByte();
                return i8;
            }
            case -47: {
                short i16 = this.readShort();
                return i16;
            }
            case -46: {
                int i32 = this.readInt();
                return i32;
            }
            case -45: {
                long i64 = this.readLong();
                return i64;
            }
        }
        throw MessageUnpacker.unexpected("Integer", b);
    }

    public BigInteger unpackBigInteger() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixInt(b)) {
            return BigInteger.valueOf(b);
        }
        switch (b) {
            case -52: {
                byte u8 = this.readByte();
                return BigInteger.valueOf(u8 & 0xFF);
            }
            case -51: {
                short u16 = this.readShort();
                return BigInteger.valueOf(u16 & 0xFFFF);
            }
            case -50: {
                int u32 = this.readInt();
                if (u32 < 0) {
                    return BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L);
                }
                return BigInteger.valueOf(u32);
            }
            case -49: {
                long u64 = this.readLong();
                if (u64 < 0L) {
                    BigInteger bi = BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
                    return bi;
                }
                return BigInteger.valueOf(u64);
            }
            case -48: {
                byte i8 = this.readByte();
                return BigInteger.valueOf(i8);
            }
            case -47: {
                short i16 = this.readShort();
                return BigInteger.valueOf(i16);
            }
            case -46: {
                int i32 = this.readInt();
                return BigInteger.valueOf(i32);
            }
            case -45: {
                long i64 = this.readLong();
                return BigInteger.valueOf(i64);
            }
        }
        throw MessageUnpacker.unexpected("Integer", b);
    }

    public float unpackFloat() throws IOException {
        byte b = this.readByte();
        switch (b) {
            case -54: {
                float fv = this.readFloat();
                return fv;
            }
            case -53: {
                double dv = this.readDouble();
                return (float)dv;
            }
        }
        throw MessageUnpacker.unexpected("Float", b);
    }

    public double unpackDouble() throws IOException {
        byte b = this.readByte();
        switch (b) {
            case -54: {
                float fv = this.readFloat();
                return fv;
            }
            case -53: {
                double dv = this.readDouble();
                return dv;
            }
        }
        throw MessageUnpacker.unexpected("Float", b);
    }

    private void resetDecoder() {
        if (this.decoder == null) {
            this.decodeBuffer = CharBuffer.allocate(this.stringDecoderBufferSize);
            this.decoder = MessagePack.UTF8.newDecoder().onMalformedInput(this.actionOnMalformedString).onUnmappableCharacter(this.actionOnUnmappableString);
        } else {
            this.decoder.reset();
        }
        if (this.decodeStringBuffer == null) {
            this.decodeStringBuffer = new StringBuilder();
        } else {
            this.decodeStringBuffer.setLength(0);
        }
    }

    public String unpackString() throws IOException {
        int len = this.unpackRawStringHeader();
        if (len == 0) {
            return EMPTY_STRING;
        }
        if (len > this.stringSizeLimit) {
            throw new MessageSizeException(String.format("cannot unpack a String of size larger than %,d: %,d", this.stringSizeLimit, len), len);
        }
        this.resetDecoder();
        if (this.buffer.size() - this.position >= len) {
            return this.decodeStringFastPath(len);
        }
        try {
            int rawRemaining = len;
            while (rawRemaining > 0) {
                int more;
                int bufferRemaining = this.buffer.size() - this.position;
                if (bufferRemaining >= rawRemaining) {
                    this.decodeStringBuffer.append(this.decodeStringFastPath(rawRemaining));
                    break;
                }
                if (bufferRemaining == 0) {
                    this.nextBuffer();
                    continue;
                }
                ByteBuffer bb = this.buffer.sliceAsByteBuffer(this.position, bufferRemaining);
                int bbStartPosition = bb.position();
                this.decodeBuffer.clear();
                CoderResult cr = this.decoder.decode(bb, this.decodeBuffer, false);
                int readLen = bb.position() - bbStartPosition;
                this.position += readLen;
                rawRemaining -= readLen;
                this.decodeStringBuffer.append(this.decodeBuffer.flip());
                if (cr.isError()) {
                    this.handleCoderError(cr);
                }
                if (!cr.isUnderflow() || readLen >= bufferRemaining) continue;
                int incompleteMultiBytes = MessageUnpacker.utf8MultibyteCharacterSize(this.buffer.getByte(this.position));
                ByteBuffer multiByteBuffer = ByteBuffer.allocate(incompleteMultiBytes);
                this.buffer.getBytes(this.position, this.buffer.size() - this.position, multiByteBuffer);
                while (true) {
                    this.nextBuffer();
                    more = multiByteBuffer.remaining();
                    if (this.buffer.size() >= more) break;
                    this.buffer.getBytes(0, this.buffer.size(), multiByteBuffer);
                    this.position = this.buffer.size();
                }
                this.buffer.getBytes(0, more, multiByteBuffer);
                this.position = more;
                multiByteBuffer.position(0);
                this.decodeBuffer.clear();
                cr = this.decoder.decode(multiByteBuffer, this.decodeBuffer, false);
                if (cr.isError()) {
                    this.handleCoderError(cr);
                }
                if (cr.isOverflow() || cr.isUnderflow() && multiByteBuffer.position() < multiByteBuffer.limit()) {
                    try {
                        cr.throwException();
                        throw new MessageFormatException("Unexpected UTF-8 multibyte sequence");
                    }
                    catch (Exception ex) {
                        throw new MessageFormatException("Unexpected UTF-8 multibyte sequence", ex);
                    }
                }
                rawRemaining -= multiByteBuffer.limit();
                this.decodeStringBuffer.append(this.decodeBuffer.flip());
            }
            return this.decodeStringBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new MessageStringCodingException(e);
        }
    }

    private void handleCoderError(CoderResult cr) throws CharacterCodingException {
        if (cr.isMalformed() && this.actionOnMalformedString == CodingErrorAction.REPORT || cr.isUnmappable() && this.actionOnUnmappableString == CodingErrorAction.REPORT) {
            cr.throwException();
        }
    }

    private String decodeStringFastPath(int length) {
        CharBuffer cb;
        if (this.actionOnMalformedString == CodingErrorAction.REPLACE && this.actionOnUnmappableString == CodingErrorAction.REPLACE && this.buffer.hasArray()) {
            String s = new String(this.buffer.array(), this.buffer.arrayOffset() + this.position, length, MessagePack.UTF8);
            this.position += length;
            return s;
        }
        ByteBuffer bb = this.buffer.sliceAsByteBuffer(this.position, length);
        try {
            cb = this.decoder.decode(bb);
        }
        catch (CharacterCodingException e) {
            throw new MessageStringCodingException(e);
        }
        this.position += length;
        return cb.toString();
    }

    public int unpackArrayHeader() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixedArray(b)) {
            return b & 0xF;
        }
        switch (b) {
            case -36: {
                int len = this.readNextLength16();
                return len;
            }
            case -35: {
                int len = this.readNextLength32();
                return len;
            }
        }
        throw MessageUnpacker.unexpected("Array", b);
    }

    public int unpackMapHeader() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixedMap(b)) {
            return b & 0xF;
        }
        switch (b) {
            case -34: {
                int len = this.readNextLength16();
                return len;
            }
            case -33: {
                int len = this.readNextLength32();
                return len;
            }
        }
        throw MessageUnpacker.unexpected("Map", b);
    }

    public ExtensionTypeHeader unpackExtensionTypeHeader() throws IOException {
        byte b = this.readByte();
        switch (b) {
            case -44: {
                byte type = this.readByte();
                return new ExtensionTypeHeader(type, 1);
            }
            case -43: {
                byte type = this.readByte();
                return new ExtensionTypeHeader(type, 2);
            }
            case -42: {
                byte type = this.readByte();
                return new ExtensionTypeHeader(type, 4);
            }
            case -41: {
                byte type = this.readByte();
                return new ExtensionTypeHeader(type, 8);
            }
            case -40: {
                byte type = this.readByte();
                return new ExtensionTypeHeader(type, 16);
            }
            case -57: {
                MessageBuffer numberBuffer = this.prepareNumberBuffer(2);
                byte u8 = numberBuffer.getByte(this.nextReadPosition);
                int length = u8 & 0xFF;
                byte type = numberBuffer.getByte(this.nextReadPosition + 1);
                return new ExtensionTypeHeader(type, length);
            }
            case -56: {
                MessageBuffer numberBuffer = this.prepareNumberBuffer(3);
                short u16 = numberBuffer.getShort(this.nextReadPosition);
                int length = u16 & 0xFFFF;
                byte type = numberBuffer.getByte(this.nextReadPosition + 2);
                return new ExtensionTypeHeader(type, length);
            }
            case -55: {
                MessageBuffer numberBuffer = this.prepareNumberBuffer(5);
                int u32 = numberBuffer.getInt(this.nextReadPosition);
                if (u32 < 0) {
                    throw MessageUnpacker.overflowU32Size(u32);
                }
                int length = u32;
                byte type = numberBuffer.getByte(this.nextReadPosition + 4);
                return new ExtensionTypeHeader(type, length);
            }
        }
        throw MessageUnpacker.unexpected("Ext", b);
    }

    private int tryReadStringHeader(byte b) throws IOException {
        switch (b) {
            case -39: {
                return this.readNextLength8();
            }
            case -38: {
                return this.readNextLength16();
            }
            case -37: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    private int tryReadBinaryHeader(byte b) throws IOException {
        switch (b) {
            case -60: {
                return this.readNextLength8();
            }
            case -59: {
                return this.readNextLength16();
            }
            case -58: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    public int unpackRawStringHeader() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixedRaw(b)) {
            return b & 0x1F;
        }
        int len = this.tryReadStringHeader(b);
        if (len >= 0) {
            return len;
        }
        if (this.allowReadingBinaryAsString && (len = this.tryReadBinaryHeader(b)) >= 0) {
            return len;
        }
        throw MessageUnpacker.unexpected("String", b);
    }

    public int unpackBinaryHeader() throws IOException {
        byte b = this.readByte();
        if (MessagePack.Code.isFixedRaw(b)) {
            return b & 0x1F;
        }
        int len = this.tryReadBinaryHeader(b);
        if (len >= 0) {
            return len;
        }
        if (this.allowReadingStringAsBinary && (len = this.tryReadStringHeader(b)) >= 0) {
            return len;
        }
        throw MessageUnpacker.unexpected("Binary", b);
    }

    private void skipPayload(int numBytes) throws IOException {
        while (true) {
            int bufferRemaining;
            if ((bufferRemaining = this.buffer.size() - this.position) >= numBytes) {
                this.position += numBytes;
                return;
            }
            this.position += bufferRemaining;
            numBytes -= bufferRemaining;
            this.nextBuffer();
        }
    }

    public void readPayload(ByteBuffer dst) throws IOException {
        while (true) {
            int dstRemaining = dst.remaining();
            int bufferRemaining = this.buffer.size() - this.position;
            if (bufferRemaining >= dstRemaining) {
                this.buffer.getBytes(this.position, dstRemaining, dst);
                this.position += dstRemaining;
                return;
            }
            this.buffer.getBytes(this.position, bufferRemaining, dst);
            this.position += bufferRemaining;
            this.nextBuffer();
        }
    }

    public void readPayload(MessageBuffer dst, int off, int len) throws IOException {
        while (true) {
            int bufferRemaining;
            if ((bufferRemaining = this.buffer.size() - this.position) >= len) {
                dst.putMessageBuffer(off, this.buffer, this.position, len);
                this.position += len;
                return;
            }
            dst.putMessageBuffer(off, this.buffer, this.position, bufferRemaining);
            off += bufferRemaining;
            len -= bufferRemaining;
            this.position += bufferRemaining;
            this.nextBuffer();
        }
    }

    public void readPayload(byte[] dst) throws IOException {
        this.readPayload(dst, 0, dst.length);
    }

    public byte[] readPayload(int length) throws IOException {
        byte[] newArray = new byte[length];
        this.readPayload(newArray);
        return newArray;
    }

    public void readPayload(byte[] dst, int off, int len) throws IOException {
        while (true) {
            int bufferRemaining;
            if ((bufferRemaining = this.buffer.size() - this.position) >= len) {
                this.buffer.getBytes(this.position, dst, off, len);
                this.position += len;
                return;
            }
            this.buffer.getBytes(this.position, dst, off, bufferRemaining);
            off += bufferRemaining;
            len -= bufferRemaining;
            this.position += bufferRemaining;
            this.nextBuffer();
        }
    }

    public MessageBuffer readPayloadAsReference(int length) throws IOException {
        int bufferRemaining = this.buffer.size() - this.position;
        if (bufferRemaining >= length) {
            MessageBuffer slice = this.buffer.slice(this.position, length);
            this.position += length;
            return slice;
        }
        MessageBuffer dst = MessageBuffer.allocate(length);
        this.readPayload(dst, 0, length);
        return dst;
    }

    private int readNextLength8() throws IOException {
        byte u8 = this.readByte();
        return u8 & 0xFF;
    }

    private int readNextLength16() throws IOException {
        short u16 = this.readShort();
        return u16 & 0xFFFF;
    }

    private int readNextLength32() throws IOException {
        int u32 = this.readInt();
        if (u32 < 0) {
            throw MessageUnpacker.overflowU32Size(u32);
        }
        return u32;
    }

    @Override
    public void close() throws IOException {
        this.buffer = EMPTY_BUFFER;
        this.position = 0;
        this.in.close();
    }

    private static MessageIntegerOverflowException overflowU8(byte u8) {
        BigInteger bi = BigInteger.valueOf(u8 & 0xFF);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowU16(short u16) {
        BigInteger bi = BigInteger.valueOf(u16 & 0xFFFF);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowU32(int u32) {
        BigInteger bi = BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowU64(long u64) {
        BigInteger bi = BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowI16(short i16) {
        BigInteger bi = BigInteger.valueOf(i16);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowI32(int i32) {
        BigInteger bi = BigInteger.valueOf(i32);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageIntegerOverflowException overflowI64(long i64) {
        BigInteger bi = BigInteger.valueOf(i64);
        return new MessageIntegerOverflowException(bi);
    }

    private static MessageSizeException overflowU32Size(int u32) {
        long lv = (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
        return new MessageSizeException(lv);
    }
}

