/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer;

import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.Preconditions;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBuffer;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.buffer.MessageBufferInput;

public class ArrayBufferInput
implements MessageBufferInput {
    private MessageBuffer buffer;
    private boolean isEmpty;

    public ArrayBufferInput(MessageBuffer buf) {
        this.buffer = buf;
        this.isEmpty = buf == null;
    }

    public ArrayBufferInput(byte[] arr) {
        this(arr, 0, arr.length);
    }

    public ArrayBufferInput(byte[] arr, int offset, int length) {
        this(MessageBuffer.wrap(Preconditions.checkNotNull(arr, "input array is null"), offset, length));
    }

    public MessageBuffer reset(MessageBuffer buf) {
        MessageBuffer old = this.buffer;
        this.buffer = buf;
        this.isEmpty = buf == null;
        return old;
    }

    public void reset(byte[] arr) {
        this.reset(MessageBuffer.wrap(Preconditions.checkNotNull(arr, "input array is null")));
    }

    public void reset(byte[] arr, int offset, int len) {
        this.reset(MessageBuffer.wrap(Preconditions.checkNotNull(arr, "input array is null"), offset, len));
    }

    @Override
    public MessageBuffer next() {
        if (this.isEmpty) {
            return null;
        }
        this.isEmpty = true;
        return this.buffer;
    }

    @Override
    public void close() {
        this.buffer = null;
        this.isEmpty = true;
    }
}

